/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.EventLoopResources;
import io.lettuce.core.resource.EventLoopResourcesWrapper;
import io.lettuce.core.resource.UnavailableResources;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringChannelOption;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringSocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;

public class IOUringProvider {
    private static final InternalLogger logger;
    private static final String IOURING_ENABLED_KEY = "io.lettuce.core.iouring";
    private static final boolean IOURING_ENABLED;
    private static final boolean IOURING_AVAILABLE;
    private static final EventLoopResources IOURING_RESOURCES;

    public static boolean isAvailable() {
        return IOURING_AVAILABLE && IOURING_ENABLED;
    }

    static void checkForIOUringLibrary() {
        LettuceAssert.assertState(IOURING_ENABLED, String.format("io_uring use is disabled via System properties (%s)", IOURING_ENABLED_KEY));
        LettuceAssert.assertState(IOUringProvider.isAvailable(), "netty-incubator-transport-native-io_uring is not available. Make sure netty-incubator-transport-native-io_uring library on the class path and supported by your operating system.");
    }

    public static EventLoopResources getResources() {
        return IOURING_RESOURCES;
    }

    public static void applyKeepAlive(Bootstrap bootstrap, int count, Duration idle, Duration interval) {
        bootstrap.option(IoUringChannelOption.TCP_KEEPCNT, (Object)count);
        bootstrap.option(IoUringChannelOption.TCP_KEEPIDLE, (Object)Math.toIntExact(idle.getSeconds()));
        bootstrap.option(IoUringChannelOption.TCP_KEEPINTVL, (Object)Math.toIntExact(interval.getSeconds()));
    }

    public static void applyTcpUserTimeout(Bootstrap bootstrap, Duration timeout) {
        bootstrap.option(IoUringChannelOption.TCP_USER_TIMEOUT, (Object)Math.toIntExact(timeout.toMillis()));
    }

    static {
        boolean availability;
        logger = InternalLoggerFactory.getInstance(IOUringProvider.class);
        IOURING_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get((String)IOURING_ENABLED_KEY, (String)"true"));
        try {
            Class.forName("io.netty.incubator.channel.uring.IOUring");
            availability = IoUring.isAvailable();
        }
        catch (ClassNotFoundException e) {
            availability = false;
        }
        IOURING_AVAILABLE = availability;
        if (IOURING_AVAILABLE) {
            logger.debug("Starting with io_uring library");
            IOURING_RESOURCES = new EventLoopResourcesWrapper(IOUringResources.INSTANCE, IOUringProvider::checkForIOUringLibrary);
        } else {
            logger.debug("Starting without optional io_uring library");
            IOURING_RESOURCES = new EventLoopResourcesWrapper(UnavailableResources.INSTANCE, IOUringProvider::checkForIOUringLibrary);
        }
    }

    static enum IOUringResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
            return type.equals(MultiThreadIoEventLoopGroup.class);
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            return MultiThreadIoEventLoopGroup.class;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            return new MultiThreadIoEventLoopGroup(nThreads, threadFactory, IoUringIoHandler.newFactory());
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            return IoUringSocketChannel.class;
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            return IoUringSocketChannel.class;
        }

        @Override
        public Class<? extends DatagramChannel> datagramChannelClass() {
            return IoUringDatagramChannel.class;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            return new DomainSocketAddress(socketPath);
        }
    }
}

