/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.EpollProvider;
import io.lettuce.core.resource.EventLoopGroupProvider;
import io.lettuce.core.resource.EventLoopResources;
import io.lettuce.core.resource.KqueueProvider;
import io.lettuce.core.resource.PromiseAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.concurrent.SucceededFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DefaultEventLoopGroupProvider
implements EventLoopGroupProvider {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultEventLoopGroupProvider.class);
    private final Map<Class<? extends EventExecutorGroup>, EventExecutorGroup> eventLoopGroups = new ConcurrentHashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(2);
    private final Map<ExecutorService, Long> refCounter = new ConcurrentHashMap<ExecutorService, Long>(2);
    private final int numberOfThreads;
    private final ThreadFactoryProvider threadFactoryProvider;
    private volatile boolean shutdownCalled = false;

    public DefaultEventLoopGroupProvider(int numberOfThreads) {
        this(numberOfThreads, DefaultThreadFactoryProvider.INSTANCE);
    }

    public DefaultEventLoopGroupProvider(int numberOfThreads, ThreadFactoryProvider threadFactoryProvider) {
        LettuceAssert.isTrue(numberOfThreads > 0, "Number of threads must be greater than zero");
        LettuceAssert.notNull((Object)threadFactoryProvider, "ThreadFactoryProvider must not be null");
        this.numberOfThreads = numberOfThreads;
        this.threadFactoryProvider = threadFactoryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends EventLoopGroup> T allocate(Class<T> type) {
        DefaultEventLoopGroupProvider defaultEventLoopGroupProvider = this;
        synchronized (defaultEventLoopGroupProvider) {
            logger.debug("Allocating executor {}", (Object)type.getName());
            return (T)((EventLoopGroup)this.addReference(this.getOrCreate(type)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutorService> T addReference(T reference) {
        Map<ExecutorService, Long> map = this.refCounter;
        synchronized (map) {
            long counter = 0L;
            if (this.refCounter.containsKey(reference)) {
                counter = this.refCounter.get(reference);
            }
            logger.debug("Adding reference to {}, existing ref count {}", reference, (Object)counter);
            this.refCounter.put(reference, ++counter);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutorService> T release(T reference) {
        Map<ExecutorService, Long> map = this.refCounter;
        synchronized (map) {
            long counter = 0L;
            if (this.refCounter.containsKey(reference)) {
                counter = this.refCounter.get(reference);
            }
            if (counter < 1L) {
                logger.debug("Attempting to release {} but ref count is {}", reference, (Object)counter);
            }
            if (--counter == 0L) {
                this.refCounter.remove(reference);
            } else {
                this.refCounter.put(reference, counter);
            }
        }
        return reference;
    }

    private <T extends EventLoopGroup> T getOrCreate(Class<T> type) {
        if (this.shutdownCalled) {
            throw new IllegalStateException("Provider is shut down and can not longer provide resources");
        }
        if (!this.eventLoopGroups.containsKey(type)) {
            this.eventLoopGroups.put(type, this.doCreateEventLoopGroup(type, this.numberOfThreads, this.threadFactoryProvider));
        }
        return (T)((EventLoopGroup)this.eventLoopGroups.get(type));
    }

    protected <T extends EventLoopGroup> EventExecutorGroup doCreateEventLoopGroup(Class<T> type, int numberOfThreads, ThreadFactoryProvider threadFactoryProvider) {
        return DefaultEventLoopGroupProvider.createEventLoopGroup(type, numberOfThreads, threadFactoryProvider);
    }

    public static <T extends EventExecutorGroup> EventExecutorGroup createEventLoopGroup(Class<T> type, int numberOfThreads) {
        return DefaultEventLoopGroupProvider.createEventLoopGroup(type, numberOfThreads, DefaultThreadFactoryProvider.INSTANCE);
    }

    private static <T extends EventExecutorGroup> EventExecutorGroup createEventLoopGroup(Class<T> type, int numberOfThreads, ThreadFactoryProvider factoryProvider) {
        EventLoopResources resources;
        logger.debug("Creating executor {}", (Object)type.getName());
        if (DefaultEventExecutorGroup.class.equals(type)) {
            return new DefaultEventExecutorGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-eventExecutorLoop"));
        }
        if (NioEventLoopGroup.class.equals(type)) {
            return new NioEventLoopGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-nioEventLoop"));
        }
        if (EpollProvider.isAvailable() && (resources = EpollProvider.getResources()).matches(type)) {
            return resources.newEventLoopGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-epollEventLoop"));
        }
        if (KqueueProvider.isAvailable() && (resources = KqueueProvider.getResources()).matches(type)) {
            return resources.newEventLoopGroup(numberOfThreads, factoryProvider.getThreadFactory("lettuce-kqueueEventLoop"));
        }
        throw new IllegalArgumentException(String.format("Type %s not supported", type.getName()));
    }

    public Promise<Boolean> release(EventExecutorGroup eventLoopGroup, long quietPeriod, long timeout, TimeUnit unit) {
        return PromiseAdapter.toBooleanPromise(this.doRelease(eventLoopGroup, quietPeriod, timeout, unit));
    }

    private Future<?> doRelease(EventExecutorGroup eventLoopGroup, long quietPeriod, long timeout, TimeUnit unit) {
        logger.debug("Release executor {}", (Object)eventLoopGroup);
        Class<?> key = this.getKey(this.release(eventLoopGroup));
        if (key == null && eventLoopGroup.isShuttingDown() || this.refCounter.containsKey(eventLoopGroup)) {
            return new SucceededFuture((EventExecutor)ImmediateEventExecutor.INSTANCE, (Object)true);
        }
        if (key != null) {
            this.eventLoopGroups.remove(key);
        }
        return eventLoopGroup.shutdownGracefully(quietPeriod, timeout, unit);
    }

    private Class<?> getKey(EventExecutorGroup eventLoopGroup) {
        Class key = null;
        HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup> copy = new HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(this.eventLoopGroups);
        for (Map.Entry entry : copy.entrySet()) {
            if (entry.getValue() != eventLoopGroup) continue;
            key = (Class)entry.getKey();
            break;
        }
        return key;
    }

    @Override
    public int threadPoolSize() {
        return this.numberOfThreads;
    }

    @Override
    public Future<Boolean> shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        logger.debug("Initiate shutdown ({}, {}, {})", new Object[]{quietPeriod, timeout, timeUnit});
        this.shutdownCalled = true;
        HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup> copy = new HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(this.eventLoopGroups);
        DefaultPromise overall = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        PromiseCombiner combiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        for (EventExecutorGroup executorGroup : copy.values()) {
            combiner.add(this.doRelease(executorGroup, quietPeriod, timeout, timeUnit));
        }
        combiner.finish((Promise)overall);
        return PromiseAdapter.toBooleanPromise(overall);
    }

    static enum DefaultThreadFactoryProvider implements ThreadFactoryProvider
    {
        INSTANCE;


        @Override
        public ThreadFactory getThreadFactory(String poolName) {
            return new DefaultThreadFactory(poolName, true);
        }
    }

    public static interface ThreadFactoryProvider {
        public ThreadFactory getThreadFactory(String var1);
    }
}

