/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.masterreplica.AsyncConnections;
import io.lettuce.core.masterreplica.NodeConnectionFactory;
import io.lettuce.core.masterreplica.RedisClientNodeConnectionFactory;
import io.lettuce.core.masterreplica.Requests;
import io.lettuce.core.masterreplica.ResumeAfter;
import io.lettuce.core.masterreplica.TopologyProvider;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import reactor.core.publisher.Mono;

class UpstreamReplicaTopologyRefresh {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(UpstreamReplicaTopologyRefresh.class);
    private static final StringCodec CODEC = StringCodec.UTF8;
    private final NodeConnectionFactory nodeConnectionFactory;
    private final TopologyProvider topologyProvider;
    private ScheduledExecutorService eventExecutors;

    UpstreamReplicaTopologyRefresh(RedisClient client, TopologyProvider topologyProvider) {
        this(new RedisClientNodeConnectionFactory(client), (ScheduledExecutorService)client.getResources().eventExecutorGroup(), topologyProvider);
    }

    UpstreamReplicaTopologyRefresh(NodeConnectionFactory nodeConnectionFactory, ScheduledExecutorService eventExecutors, TopologyProvider topologyProvider) {
        this.nodeConnectionFactory = nodeConnectionFactory;
        this.eventExecutors = eventExecutors;
        this.topologyProvider = topologyProvider;
    }

    public Mono<List<RedisNodeDescription>> getNodes(RedisURI seed) {
        CompletableFuture<List<RedisNodeDescription>> future = this.topologyProvider.getNodesAsync();
        Mono initialNodes = Mono.fromFuture(future).doOnNext(nodes -> UpstreamReplicaTopologyRefresh.addPasswordIfNeeded(nodes, seed));
        return initialNodes.map(this::getConnections).flatMap(asyncConnections -> asyncConnections.asMono(seed.getTimeout(), this.eventExecutors)).flatMap(connections -> {
            Requests requests = connections.requestPing();
            CompletionStage nodes = requests.getOrTimeout(seed.getTimeout(), this.eventExecutors);
            return Mono.fromCompletionStage(nodes).flatMap(it -> ResumeAfter.close(connections).thenEmit(it));
        });
    }

    private AsyncConnections getConnections(Iterable<RedisNodeDescription> nodes) {
        List<RedisNodeDescription> nodeList = LettuceLists.newList(nodes);
        AsyncConnections connections = new AsyncConnections(nodeList);
        for (RedisNodeDescription node : nodeList) {
            RedisURI redisURI = node.getUri();
            String message = String.format("Unable to connect to %s", redisURI);
            try {
                CompletableFuture<StatefulRedisConnection<String, String>> connectionFuture = this.nodeConnectionFactory.connectToNodeAsync(CODEC, redisURI);
                CompletableFuture<StatefulRedisConnection<String, String>> sync = new CompletableFuture<StatefulRedisConnection<String, String>>();
                connectionFuture.whenComplete((connection, throwable) -> {
                    if (throwable != null) {
                        if (throwable instanceof RedisConnectionException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(throwable.getMessage(), throwable);
                            } else {
                                logger.warn(throwable.getMessage());
                            }
                        } else {
                            logger.warn(message, throwable);
                        }
                        sync.completeExceptionally(new RedisConnectionException(message, (Throwable)throwable));
                    } else {
                        connection.async().clientSetname("lettuce#MasterReplicaTopologyRefresh");
                        sync.complete((StatefulRedisConnection<String, String>)connection);
                    }
                });
                connections.addConnection(redisURI, sync);
            }
            catch (RuntimeException e) {
                logger.warn(String.format(message, redisURI), (Throwable)e);
            }
        }
        return connections;
    }

    private static void addPasswordIfNeeded(List<RedisNodeDescription> nodes, RedisURI seed) {
        if (seed.getPassword() != null && seed.getPassword().length != 0) {
            for (RedisNodeDescription node : nodes) {
                node.getUri().setPassword(new String(seed.getPassword()));
            }
        }
    }
}

