/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.ReplicaTopologyProvider;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.masterreplica.StatefulRedisUpstreamReplicaConnectionImpl;
import io.lettuce.core.masterreplica.UpstreamReplicaChannelWriter;
import io.lettuce.core.masterreplica.UpstreamReplicaConnectionProvider;
import io.lettuce.core.masterreplica.UpstreamReplicaConnector;
import io.lettuce.core.masterreplica.UpstreamReplicaTopologyRefresh;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class AutodiscoveryConnector<K, V>
implements UpstreamReplicaConnector<K, V> {
    private final RedisClient redisClient;
    private final RedisCodec<K, V> codec;
    private final RedisURI redisURI;
    private final Map<RedisURI, StatefulRedisConnection<?, ?>> initialConnections = new ConcurrentHashMap();

    AutodiscoveryConnector(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        this.redisClient = redisClient;
        this.codec = codec;
        this.redisURI = redisURI;
    }

    @Override
    public CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsync() {
        ConnectionFuture<StatefulRedisConnection<K, V>> initialConnection = this.redisClient.connectAsync(this.codec, this.redisURI);
        Mono connect = Mono.fromCompletionStage(initialConnection).flatMap(nodeConnection -> {
            this.initialConnections.put(this.redisURI, (StatefulRedisConnection<?, ?>)nodeConnection);
            ReplicaTopologyProvider topologyProvider = new ReplicaTopologyProvider((StatefulRedisConnection<?, ?>)nodeConnection, this.redisURI);
            return Mono.fromCompletionStage(topologyProvider.getNodesAsync()).flatMap(nodes -> this.getMasterConnectionAndUri((List<RedisNodeDescription>)nodes, (Tuple2<RedisURI, StatefulRedisConnection<K, V>>)Tuples.of((Object)this.redisURI, (Object)nodeConnection), this.codec));
        }).flatMap(connectionAndUri -> this.initializeConnection(this.codec, (Tuple2<RedisURI, StatefulRedisConnection<K, V>>)connectionAndUri));
        return connect.onErrorResume(t -> {
            Mono close = Mono.empty();
            for (StatefulRedisConnection<?, ?> connection : this.initialConnections.values()) {
                close = close.then(Mono.fromFuture(connection.closeAsync()));
            }
            return close.then(Mono.error((Throwable)t));
        }).onErrorMap(ExecutionException.class, Throwable::getCause).toFuture();
    }

    private Mono<Tuple2<RedisURI, StatefulRedisConnection<K, V>>> getMasterConnectionAndUri(List<RedisNodeDescription> nodes, Tuple2<RedisURI, StatefulRedisConnection<K, V>> connectionTuple, RedisCodec<K, V> codec) {
        RedisNodeDescription node = AutodiscoveryConnector.getConnectedNode(this.redisURI, nodes);
        if (!node.getRole().isUpstream()) {
            RedisNodeDescription master = AutodiscoveryConnector.lookupMaster(nodes);
            ConnectionFuture<StatefulRedisConnection<K, V>> masterConnection = this.redisClient.connectAsync(codec, master.getUri());
            return Mono.just((Object)master.getUri()).zipWith(Mono.fromCompletionStage(masterConnection)).doOnNext(it -> this.initialConnections.put((RedisURI)it.getT1(), (StatefulRedisConnection<?, ?>)it.getT2()));
        }
        return Mono.just(connectionTuple);
    }

    private Mono<StatefulRedisMasterReplicaConnection<K, V>> initializeConnection(RedisCodec<K, V> codec, Tuple2<RedisURI, StatefulRedisConnection<K, V>> connectionAndUri) {
        ReplicaTopologyProvider topologyProvider = new ReplicaTopologyProvider((StatefulRedisConnection)connectionAndUri.getT2(), (RedisURI)connectionAndUri.getT1());
        UpstreamReplicaTopologyRefresh refresh = new UpstreamReplicaTopologyRefresh(this.redisClient, topologyProvider);
        UpstreamReplicaConnectionProvider<K, V> connectionProvider = new UpstreamReplicaConnectionProvider<K, V>(this.redisClient, codec, this.redisURI, this.initialConnections);
        Mono<List<RedisNodeDescription>> refreshFuture = refresh.getNodes(this.redisURI);
        return refreshFuture.map(nodes -> {
            connectionProvider.setKnownNodes((Collection<RedisNodeDescription>)nodes);
            UpstreamReplicaChannelWriter channelWriter = new UpstreamReplicaChannelWriter(connectionProvider, this.redisClient.getResources());
            StatefulRedisUpstreamReplicaConnectionImpl connection = new StatefulRedisUpstreamReplicaConnectionImpl(channelWriter, codec, this.redisURI.getTimeout());
            connection.setOptions(this.redisClient.getOptions());
            return connection;
        });
    }

    private static RedisNodeDescription lookupMaster(List<RedisNodeDescription> nodes) {
        Optional<RedisNodeDescription> first = AutodiscoveryConnector.findFirst(nodes, n -> n.getRole().isUpstream());
        return first.orElseThrow(() -> new IllegalStateException("Cannot lookup master from " + nodes));
    }

    private static RedisNodeDescription getConnectedNode(RedisURI redisURI, List<RedisNodeDescription> nodes) {
        Optional<RedisNodeDescription> first = AutodiscoveryConnector.findFirst(nodes, n -> AutodiscoveryConnector.equals(redisURI, n));
        return first.orElseThrow(() -> new IllegalStateException("Cannot lookup node descriptor for connected node at " + redisURI));
    }

    private static Optional<RedisNodeDescription> findFirst(List<RedisNodeDescription> nodes, Predicate<? super RedisNodeDescription> predicate) {
        return nodes.stream().filter(predicate).findFirst();
    }

    private static boolean equals(RedisURI redisURI, RedisNodeDescription node) {
        return node.getUri().getHost().equals(redisURI.getHost()) && node.getUri().getPort() == redisURI.getPort();
    }
}

