/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.RedisURI;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.Collection;
import java.util.Comparator;

class MasterReplicaUtils {
    MasterReplicaUtils() {
    }

    static boolean isChanged(Collection<RedisNodeDescription> o1, Collection<RedisNodeDescription> o2) {
        if (o1.size() != o2.size()) {
            return true;
        }
        for (RedisNodeDescription base : o2) {
            if (MasterReplicaUtils.essentiallyEqualsTo(base, MasterReplicaUtils.findNodeByUri(o1, base.getUri()))) continue;
            return true;
        }
        return false;
    }

    static RedisNodeDescription findNodeByUri(Collection<RedisNodeDescription> nodes, RedisURI lookupUri) {
        return MasterReplicaUtils.findNodeByHostAndPort(nodes, lookupUri.getHost(), lookupUri.getPort());
    }

    static RedisNodeDescription findNodeByHostAndPort(Collection<RedisNodeDescription> nodes, String host, int port) {
        for (RedisNodeDescription node : nodes) {
            RedisURI nodeUri = node.getUri();
            if (!nodeUri.getHost().equals(host) || nodeUri.getPort() != port) continue;
            return node;
        }
        return null;
    }

    static boolean essentiallyEqualsTo(RedisNodeDescription o1, RedisNodeDescription o2) {
        if (o2 == null) {
            return false;
        }
        if (o1.getRole() != o2.getRole()) {
            return false;
        }
        return o1.getUri().equals(o2.getUri());
    }

    static enum RedisURIComparator implements Comparator<RedisURI>
    {
        INSTANCE;


        @Override
        public int compare(RedisURI o1, RedisURI o2) {
            String h1 = "";
            String h2 = "";
            if (o1 != null) {
                h1 = o1.getHost() + ":" + o1.getPort();
            }
            if (o2 != null) {
                h2 = o2.getHost() + ":" + o2.getPort();
            }
            return h1.compareToIgnoreCase(h2);
        }
    }
}

