/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.pubsub.api.reactive;

import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.cluster.pubsub.api.reactive.PubSubReactiveNodeSelection;
import io.lettuce.core.pubsub.api.reactive.RedisPubSubReactiveCommands;
import java.util.function.Predicate;

public interface RedisClusterPubSubReactiveCommands<K, V>
extends RedisPubSubReactiveCommands<K, V> {
    @Override
    public StatefulRedisClusterPubSubConnection<K, V> getStatefulConnection();

    default public PubSubReactiveNodeSelection<K, V> masters() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.MASTER));
    }

    @Deprecated
    default public PubSubReactiveNodeSelection<K, V> slaves() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    @Deprecated
    default public PubSubReactiveNodeSelection<K, V> slaves(Predicate<RedisClusterNode> predicate) {
        return this.nodes(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public PubSubReactiveNodeSelection<K, V> replicas() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public PubSubReactiveNodeSelection<K, V> replicas(Predicate<RedisClusterNode> predicate) {
        return this.nodes(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public PubSubReactiveNodeSelection<K, V> all() {
        return this.nodes(redisClusterNode -> true);
    }

    public PubSubReactiveNodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1);
}

