/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisAsyncCommandsImpl;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisReactiveCommandsImpl;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.reactive.RedisReactiveCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.MultiOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandArgsAccessor;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.protocol.TransactionalCommand;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public class StatefulRedisConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisConnection<K, V> {
    protected final RedisCodec<K, V> codec;
    protected final RedisCommands<K, V> sync;
    protected final RedisAsyncCommandsImpl<K, V> async;
    protected final RedisReactiveCommandsImpl<K, V> reactive;
    protected MultiOutput<K, V> multi;
    private char[] password;
    private int db;
    private boolean readOnly;
    private String clientName;

    public StatefulRedisConnectionImpl(RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout) {
        super(writer, timeout);
        this.codec = codec;
        this.async = this.newRedisAsyncCommandsImpl();
        this.sync = this.newRedisSyncCommandsImpl();
        this.reactive = this.newRedisReactiveCommandsImpl();
    }

    @Override
    public RedisAsyncCommands<K, V> async() {
        return this.async;
    }

    protected RedisCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisCommands)this.syncHandler(this.async(), RedisCommands.class, RedisClusterCommands.class);
    }

    protected RedisAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisAsyncCommandsImpl<K, V>(this, this.codec);
    }

    @Override
    public RedisReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    protected RedisReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisReactiveCommandsImpl<K, V>(this, this.codec);
    }

    @Override
    public RedisCommands<K, V> sync() {
        return this.sync;
    }

    @Override
    public boolean isMulti() {
        return this.multi != null;
    }

    @Override
    public void activated() {
        super.activated();
        if (this.password != null) {
            this.async.authAsync(this.password);
        }
        if (this.db != 0) {
            this.async.selectAsync(this.db);
        }
        if (this.clientName != null) {
            this.setClientName(this.clientName);
        }
        if (this.readOnly) {
            this.async.readOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> command) {
        RedisCommand<K, V, T> redisCommand;
        block3: {
            RedisCommand<K, V, T> toSend = this.preProcessCommand(command);
            try {
                redisCommand = super.dispatch(toSend);
                if (!command.getType().name().equals(CommandType.MULTI.name())) break block3;
                this.multi = this.multi == null ? new MultiOutput<K, V>(this.codec) : this.multi;
            }
            catch (Throwable throwable) {
                if (command.getType().name().equals(CommandType.MULTI.name())) {
                    this.multi = this.multi == null ? new MultiOutput<K, V>(this.codec) : this.multi;
                }
                throw throwable;
            }
        }
        return redisCommand;
    }

    @Override
    public Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        ArrayList sentCommands = new ArrayList(commands.size());
        commands.forEach(o -> {
            RedisCommand command = this.preProcessCommand((RedisCommand)o);
            sentCommands.add(command);
            if (command.getType().name().equals(CommandType.MULTI.name())) {
                this.multi = this.multi == null ? new MultiOutput<K, V>(this.codec) : this.multi;
            }
        });
        return super.dispatch(sentCommands);
    }

    protected <T> RedisCommand<K, V, T> preProcessCommand(RedisCommand<K, V, T> command) {
        RedisCommand<K, V, Object> local = command;
        if (local.getType().name().equals(CommandType.AUTH.name())) {
            local = this.attachOnComplete(local, status -> {
                if ("OK".equals(status)) {
                    char[] password = CommandArgsAccessor.getFirstCharArray(command.getArgs());
                    if (password != null) {
                        this.password = password;
                    } else {
                        String stringPassword = CommandArgsAccessor.getFirstString(command.getArgs());
                        if (stringPassword != null) {
                            this.password = stringPassword.toCharArray();
                        }
                    }
                }
            });
        }
        if (local.getType().name().equals(CommandType.SELECT.name())) {
            local = this.attachOnComplete(local, status -> {
                Long db;
                if ("OK".equals(status) && (db = CommandArgsAccessor.getFirstInteger(command.getArgs())) != null) {
                    this.db = db.intValue();
                }
            });
        }
        if (local.getType().name().equals(CommandType.READONLY.name())) {
            local = this.attachOnComplete(local, status -> {
                if ("OK".equals(status)) {
                    this.readOnly = true;
                }
            });
        }
        if (local.getType().name().equals(CommandType.READWRITE.name())) {
            local = this.attachOnComplete(local, status -> {
                if ("OK".equals(status)) {
                    this.readOnly = false;
                }
            });
        }
        if (local.getType().name().equals(CommandType.DISCARD.name()) && this.multi != null) {
            this.multi.cancel();
            this.multi = null;
        }
        if (local.getType().name().equals(CommandType.EXEC.name())) {
            MultiOutput<K, V> multiOutput = this.multi;
            this.multi = null;
            if (multiOutput == null) {
                multiOutput = new MultiOutput<K, V>(this.codec);
            }
            local.setOutput(multiOutput);
        }
        if (this.multi != null) {
            local = new TransactionalCommand<K, V, Object>(local);
            this.multi.add(local);
        }
        return local;
    }

    private <T> RedisCommand<K, V, T> attachOnComplete(RedisCommand<K, V, T> command, Consumer<T> consumer) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete(consumer);
        }
        return command;
    }

    public void setClientName(String clientName) {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.SETNAME).addValue(clientName);
        AsyncCommand async = new AsyncCommand(new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args));
        this.clientName = clientName;
        this.dispatch(async);
    }
}

