/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.util.PatchUtils;

public class KubectlScale<ApiType extends KubernetesObject>
extends Kubectl.ResourceBuilder<ApiType, KubectlScale<ApiType>>
implements Kubectl.Executable<ApiType> {
    private int replicas = -1;

    KubectlScale(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlScale<ApiType> replicas(int replicas) {
        this.replicas = replicas;
        return this;
    }

    @Override
    public ApiType execute() throws KubectlException {
        this.validate();
        String jsonPatchStr = String.format("[{\"op\":\"replace\",\"path\":\"/spec/replicas\",\"value\":%d}]", this.replicas);
        AppsV1Api api = new AppsV1Api(this.apiClient);
        try {
            if (this.apiTypeClass.equals(V1Deployment.class)) {
                return (ApiType)((KubernetesObject)PatchUtils.patch((Class)this.apiTypeClass, () -> api.patchNamespacedDeploymentCall(this.name, this.namespace, new V1Patch(jsonPatchStr), null, null, null, null, null), (String)"application/json-patch+json", (ApiClient)this.apiClient));
            }
            if (this.apiTypeClass.equals(V1ReplicaSet.class)) {
                return (ApiType)((KubernetesObject)PatchUtils.patch((Class)this.apiTypeClass, () -> api.patchNamespacedReplicaSetCall(this.name, this.namespace, new V1Patch(jsonPatchStr), null, null, null, null, null), (String)"application/json-patch+json", (ApiClient)this.apiClient));
            }
            if (this.apiTypeClass.equals(V1StatefulSet.class)) {
                return (ApiType)((KubernetesObject)PatchUtils.patch((Class)this.apiTypeClass, () -> api.patchNamespacedStatefulSetCall(this.name, this.namespace, new V1Patch(jsonPatchStr), null, null, null, null, null), (String)"application/json-patch+json", (ApiClient)this.apiClient));
            }
            throw new KubectlException("Unsupported class for scale: " + this.apiTypeClass);
        }
        catch (ApiException ex) {
            throw new KubectlException(ex);
        }
    }

    private void validate() throws KubectlException {
        StringBuilder msg = new StringBuilder();
        if (this.name == null) {
            msg.append("Missing name, ");
        }
        if (this.namespace == null) {
            msg.append("Missing namespace, ");
        }
        if (this.replicas < 0) {
            msg.append("Invalid replicas");
        }
        if (msg.length() > 0) {
            throw new KubectlException(msg.toString());
        }
    }
}

