/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1IngressBackend;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1IngressRule;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1IngressTLS;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IngressSpec describes the Ingress the user wishes to exist.")
public class ExtensionsV1beta1IngressSpec {
    public static final String SERIALIZED_NAME_BACKEND = "backend";
    @SerializedName(value="backend")
    private ExtensionsV1beta1IngressBackend backend;
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<ExtensionsV1beta1IngressRule> rules = null;
    public static final String SERIALIZED_NAME_TLS = "tls";
    @SerializedName(value="tls")
    private List<ExtensionsV1beta1IngressTLS> tls = null;

    public ExtensionsV1beta1IngressSpec backend(ExtensionsV1beta1IngressBackend backend) {
        this.backend = backend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExtensionsV1beta1IngressBackend getBackend() {
        return this.backend;
    }

    public void setBackend(ExtensionsV1beta1IngressBackend backend) {
        this.backend = backend;
    }

    public ExtensionsV1beta1IngressSpec rules(List<ExtensionsV1beta1IngressRule> rules) {
        this.rules = rules;
        return this;
    }

    public ExtensionsV1beta1IngressSpec addRulesItem(ExtensionsV1beta1IngressRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<ExtensionsV1beta1IngressRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.")
    public List<ExtensionsV1beta1IngressRule> getRules() {
        return this.rules;
    }

    public void setRules(List<ExtensionsV1beta1IngressRule> rules) {
        this.rules = rules;
    }

    public ExtensionsV1beta1IngressSpec tls(List<ExtensionsV1beta1IngressTLS> tls) {
        this.tls = tls;
        return this;
    }

    public ExtensionsV1beta1IngressSpec addTlsItem(ExtensionsV1beta1IngressTLS tlsItem) {
        if (this.tls == null) {
            this.tls = new ArrayList<ExtensionsV1beta1IngressTLS>();
        }
        this.tls.add(tlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.")
    public List<ExtensionsV1beta1IngressTLS> getTls() {
        return this.tls;
    }

    public void setTls(List<ExtensionsV1beta1IngressTLS> tls) {
        this.tls = tls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionsV1beta1IngressSpec extensionsV1beta1IngressSpec = (ExtensionsV1beta1IngressSpec)o;
        return Objects.equals(this.backend, extensionsV1beta1IngressSpec.backend) && Objects.equals(this.rules, extensionsV1beta1IngressSpec.rules) && Objects.equals(this.tls, extensionsV1beta1IngressSpec.tls);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.rules, this.tls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtensionsV1beta1IngressSpec {\n");
        sb.append("    backend: ").append(this.toIndentedString(this.backend)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    tls: ").append(this.toIndentedString(this.tls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

