package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1beta1NetworkPolicySpecFluentImpl<A extends V1beta1NetworkPolicySpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1NetworkPolicySpecFluent<A>{

    private List<V1beta1NetworkPolicyEgressRuleBuilder> egress;
    private List<V1beta1NetworkPolicyIngressRuleBuilder> ingress;
    private V1LabelSelectorBuilder podSelector;
    private List<String> policyTypes;

    public V1beta1NetworkPolicySpecFluentImpl(){
    }
    public V1beta1NetworkPolicySpecFluentImpl(V1beta1NetworkPolicySpec instance){
            this.withEgress(instance.getEgress());

            this.withIngress(instance.getIngress());

            this.withPodSelector(instance.getPodSelector());

            this.withPolicyTypes(instance.getPolicyTypes());

    }

    public A addToEgress(int index,V1beta1NetworkPolicyEgressRule item){
            if (this.egress == null) {this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();}
            V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").add(index >= 0 ? index : _visitables.get("egress").size(), builder);this.egress.add(index >= 0 ? index : egress.size(), builder); return (A)this;
    }

    public A setToEgress(int index,V1beta1NetworkPolicyEgressRule item){
            if (this.egress == null) {this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();}
            V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);
            if (index < 0 || index >= _visitables.get("egress").size()) { _visitables.get("egress").add(builder); } else { _visitables.get("egress").set(index, builder);}
            if (index < 0 || index >= egress.size()) { egress.add(builder); } else { egress.set(index, builder);}
             return (A)this;
    }

    public A addToEgress(V1beta1NetworkPolicyEgressRule... items){
            if (this.egress == null) {this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();}
            for (V1beta1NetworkPolicyEgressRule item : items) {V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
    }

    public A addAllToEgress(Collection<V1beta1NetworkPolicyEgressRule> items){
            if (this.egress == null) {this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();}
            for (V1beta1NetworkPolicyEgressRule item : items) {V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
    }

    public A removeFromEgress(V1beta1NetworkPolicyEgressRule... items){
            for (V1beta1NetworkPolicyEgressRule item : items) {V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
    }

    public A removeAllFromEgress(Collection<V1beta1NetworkPolicyEgressRule> items){
            for (V1beta1NetworkPolicyEgressRule item : items) {V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEgress(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyEgressRuleBuilder> predicate){
            if (egress == null) return (A) this;
            final Iterator<V1beta1NetworkPolicyEgressRuleBuilder> each = egress.iterator();
            final List visitables = _visitables.get("egress");
            while (each.hasNext()) {
              V1beta1NetworkPolicyEgressRuleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEgress instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1NetworkPolicyEgressRule> getEgress(){
            return build(egress);
    }

    public List<V1beta1NetworkPolicyEgressRule> buildEgress(){
            return build(egress);
    }

    public V1beta1NetworkPolicyEgressRule buildEgress(int index){
            return this.egress.get(index).build();
    }

    public V1beta1NetworkPolicyEgressRule buildFirstEgress(){
            return this.egress.get(0).build();
    }

    public V1beta1NetworkPolicyEgressRule buildLastEgress(){
            return this.egress.get(egress.size() - 1).build();
    }

    public V1beta1NetworkPolicyEgressRule buildMatchingEgress(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyEgressRuleBuilder> predicate){
            for (V1beta1NetworkPolicyEgressRuleBuilder item: egress) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEgress(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyEgressRuleBuilder> predicate){
            for (V1beta1NetworkPolicyEgressRuleBuilder item: egress) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEgress(List<V1beta1NetworkPolicyEgressRule> egress){
            if (this.egress != null) { _visitables.get("egress").removeAll(this.egress);}
            if (egress != null) {this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>(); for (V1beta1NetworkPolicyEgressRule item : egress){this.addToEgress(item);}} else { this.egress = null;} return (A) this;
    }

    public A withEgress(V1beta1NetworkPolicyEgressRule... egress){
            if (this.egress != null) {this.egress.clear();}
            if (egress != null) {for (V1beta1NetworkPolicyEgressRule item :egress){ this.addToEgress(item);}} return (A) this;
    }

    public Boolean hasEgress(){
            return egress != null && !egress.isEmpty();
    }

    public V1beta1NetworkPolicySpecFluent.EgressNested<A> addNewEgress(){
            return new EgressNestedImpl();
    }

    public V1beta1NetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(V1beta1NetworkPolicyEgressRule item){
            return new EgressNestedImpl(-1, item);
    }

    public V1beta1NetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(int index,V1beta1NetworkPolicyEgressRule item){
            return new EgressNestedImpl(index, item);
    }

    public V1beta1NetworkPolicySpecFluent.EgressNested<A> editEgress(int index){
            if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public V1beta1NetworkPolicySpecFluent.EgressNested<A> editFirstEgress(){
            if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
            return setNewEgressLike(0, buildEgress(0));
    }

    public V1beta1NetworkPolicySpecFluent.EgressNested<A> editLastEgress(){
            int index = egress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public V1beta1NetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyEgressRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<egress.size();i++) { 
            if (predicate.apply(egress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public A addToIngress(int index,V1beta1NetworkPolicyIngressRule item){
            if (this.ingress == null) {this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();}
            V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
    }

    public A setToIngress(int index,V1beta1NetworkPolicyIngressRule item){
            if (this.ingress == null) {this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();}
            V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);
            if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
            if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
             return (A)this;
    }

    public A addToIngress(V1beta1NetworkPolicyIngressRule... items){
            if (this.ingress == null) {this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();}
            for (V1beta1NetworkPolicyIngressRule item : items) {V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A addAllToIngress(Collection<V1beta1NetworkPolicyIngressRule> items){
            if (this.ingress == null) {this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();}
            for (V1beta1NetworkPolicyIngressRule item : items) {V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A removeFromIngress(V1beta1NetworkPolicyIngressRule... items){
            for (V1beta1NetworkPolicyIngressRule item : items) {V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
    }

    public A removeAllFromIngress(Collection<V1beta1NetworkPolicyIngressRule> items){
            for (V1beta1NetworkPolicyIngressRule item : items) {V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIngress(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyIngressRuleBuilder> predicate){
            if (ingress == null) return (A) this;
            final Iterator<V1beta1NetworkPolicyIngressRuleBuilder> each = ingress.iterator();
            final List visitables = _visitables.get("ingress");
            while (each.hasNext()) {
              V1beta1NetworkPolicyIngressRuleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIngress instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1NetworkPolicyIngressRule> getIngress(){
            return build(ingress);
    }

    public List<V1beta1NetworkPolicyIngressRule> buildIngress(){
            return build(ingress);
    }

    public V1beta1NetworkPolicyIngressRule buildIngress(int index){
            return this.ingress.get(index).build();
    }

    public V1beta1NetworkPolicyIngressRule buildFirstIngress(){
            return this.ingress.get(0).build();
    }

    public V1beta1NetworkPolicyIngressRule buildLastIngress(){
            return this.ingress.get(ingress.size() - 1).build();
    }

    public V1beta1NetworkPolicyIngressRule buildMatchingIngress(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyIngressRuleBuilder> predicate){
            for (V1beta1NetworkPolicyIngressRuleBuilder item: ingress) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIngress(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyIngressRuleBuilder> predicate){
            for (V1beta1NetworkPolicyIngressRuleBuilder item: ingress) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withIngress(List<V1beta1NetworkPolicyIngressRule> ingress){
            if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
            if (ingress != null) {this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>(); for (V1beta1NetworkPolicyIngressRule item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
    }

    public A withIngress(V1beta1NetworkPolicyIngressRule... ingress){
            if (this.ingress != null) {this.ingress.clear();}
            if (ingress != null) {for (V1beta1NetworkPolicyIngressRule item :ingress){ this.addToIngress(item);}} return (A) this;
    }

    public Boolean hasIngress(){
            return ingress != null && !ingress.isEmpty();
    }

    public V1beta1NetworkPolicySpecFluent.IngressNested<A> addNewIngress(){
            return new IngressNestedImpl();
    }

    public V1beta1NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(V1beta1NetworkPolicyIngressRule item){
            return new IngressNestedImpl(-1, item);
    }

    public V1beta1NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(int index,V1beta1NetworkPolicyIngressRule item){
            return new IngressNestedImpl(index, item);
    }

    public V1beta1NetworkPolicySpecFluent.IngressNested<A> editIngress(int index){
            if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public V1beta1NetworkPolicySpecFluent.IngressNested<A> editFirstIngress(){
            if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
            return setNewIngressLike(0, buildIngress(0));
    }

    public V1beta1NetworkPolicySpecFluent.IngressNested<A> editLastIngress(){
            int index = ingress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public V1beta1NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyIngressRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<ingress.size();i++) { 
            if (predicate.apply(ingress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
            return setNewIngressLike(index, buildIngress(index));
    }

    
/**
 * This method has been deprecated, please use method buildPodSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getPodSelector(){
            return this.podSelector!=null?this.podSelector.build():null;
    }

    public V1LabelSelector buildPodSelector(){
            return this.podSelector!=null?this.podSelector.build():null;
    }

    public A withPodSelector(V1LabelSelector podSelector){
            _visitables.get("podSelector").remove(this.podSelector);
            if (podSelector!=null){ this.podSelector= new V1LabelSelectorBuilder(podSelector); _visitables.get("podSelector").add(this.podSelector);} return (A) this;
    }

    public Boolean hasPodSelector(){
            return this.podSelector != null;
    }

    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector(){
            return new PodSelectorNestedImpl();
    }

    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(V1LabelSelector item){
            return new PodSelectorNestedImpl(item);
    }

    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector(){
            return withNewPodSelectorLike(getPodSelector());
    }

    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector(){
            return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(V1LabelSelector item){
            return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): item);
    }

    public A addToPolicyTypes(int index,String item){
            if (this.policyTypes == null) {this.policyTypes = new ArrayList<String>();}
            this.policyTypes.add(index, item);
            return (A)this;
    }

    public A setToPolicyTypes(int index,String item){
            if (this.policyTypes == null) {this.policyTypes = new ArrayList<String>();}
            this.policyTypes.set(index, item); return (A)this;
    }

    public A addToPolicyTypes(String... items){
            if (this.policyTypes == null) {this.policyTypes = new ArrayList<String>();}
            for (String item : items) {this.policyTypes.add(item);} return (A)this;
    }

    public A addAllToPolicyTypes(Collection<String> items){
            if (this.policyTypes == null) {this.policyTypes = new ArrayList<String>();}
            for (String item : items) {this.policyTypes.add(item);} return (A)this;
    }

    public A removeFromPolicyTypes(String... items){
            for (String item : items) {if (this.policyTypes!= null){ this.policyTypes.remove(item);}} return (A)this;
    }

    public A removeAllFromPolicyTypes(Collection<String> items){
            for (String item : items) {if (this.policyTypes!= null){ this.policyTypes.remove(item);}} return (A)this;
    }

    public List<String> getPolicyTypes(){
            return this.policyTypes;
    }

    public String getPolicyType(int index){
            return this.policyTypes.get(index);
    }

    public String getFirstPolicyType(){
            return this.policyTypes.get(0);
    }

    public String getLastPolicyType(){
            return this.policyTypes.get(policyTypes.size() - 1);
    }

    public String getMatchingPolicyType(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: policyTypes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPolicyType(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: policyTypes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPolicyTypes(List<String> policyTypes){
            if (this.policyTypes != null) { _visitables.get("policyTypes").removeAll(this.policyTypes);}
            if (policyTypes != null) {this.policyTypes = new ArrayList<String>(); for (String item : policyTypes){this.addToPolicyTypes(item);}} else { this.policyTypes = null;} return (A) this;
    }

    public A withPolicyTypes(String... policyTypes){
            if (this.policyTypes != null) {this.policyTypes.clear();}
            if (policyTypes != null) {for (String item :policyTypes){ this.addToPolicyTypes(item);}} return (A) this;
    }

    public Boolean hasPolicyTypes(){
            return policyTypes != null && !policyTypes.isEmpty();
    }

    public A addNewPolicyType(String arg1){
            return (A)addToPolicyTypes(new String(arg1));
    }

    public A addNewPolicyType(StringBuilder arg1){
            return (A)addToPolicyTypes(new String(arg1));
    }

    public A addNewPolicyType(StringBuffer arg1){
            return (A)addToPolicyTypes(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1NetworkPolicySpecFluentImpl that = (V1beta1NetworkPolicySpecFluentImpl) o;
            if (egress != null ? !egress.equals(that.egress) :that.egress != null) return false;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            if (podSelector != null ? !podSelector.equals(that.podSelector) :that.podSelector != null) return false;
            if (policyTypes != null ? !policyTypes.equals(that.policyTypes) :that.policyTypes != null) return false;
            return true;
    }


    public class EgressNestedImpl<N> extends V1beta1NetworkPolicyEgressRuleFluentImpl<V1beta1NetworkPolicySpecFluent.EgressNested<N>> implements V1beta1NetworkPolicySpecFluent.EgressNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1NetworkPolicyEgressRuleBuilder builder;
        private final int index;
    
            EgressNestedImpl(int index,V1beta1NetworkPolicyEgressRule item){
                    this.index = index;
                    this.builder = new V1beta1NetworkPolicyEgressRuleBuilder(this, item);
            }
            EgressNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1NetworkPolicyEgressRuleBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicySpecFluentImpl.this.setToEgress(index,builder.build());
    }
    public N endEgress(){
            return and();
    }

}
    public class IngressNestedImpl<N> extends V1beta1NetworkPolicyIngressRuleFluentImpl<V1beta1NetworkPolicySpecFluent.IngressNested<N>> implements V1beta1NetworkPolicySpecFluent.IngressNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1NetworkPolicyIngressRuleBuilder builder;
        private final int index;
    
            IngressNestedImpl(int index,V1beta1NetworkPolicyIngressRule item){
                    this.index = index;
                    this.builder = new V1beta1NetworkPolicyIngressRuleBuilder(this, item);
            }
            IngressNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1NetworkPolicyIngressRuleBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicySpecFluentImpl.this.setToIngress(index,builder.build());
    }
    public N endIngress(){
            return and();
    }

}
    public class PodSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1NetworkPolicySpecFluent.PodSelectorNested<N>> implements V1beta1NetworkPolicySpecFluent.PodSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            PodSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            PodSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicySpecFluentImpl.this.withPodSelector(builder.build());
    }
    public N endPodSelector(){
            return and();
    }

}


}
