package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CustomResourceValidationBuilder extends V1beta1CustomResourceValidationFluentImpl<V1beta1CustomResourceValidationBuilder> implements VisitableBuilder<V1beta1CustomResourceValidation,V1beta1CustomResourceValidationBuilder>{

    V1beta1CustomResourceValidationFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1CustomResourceValidationBuilder(){
            this(true);
    }
    public V1beta1CustomResourceValidationBuilder(Boolean validationEnabled){
            this(new V1beta1CustomResourceValidation(), validationEnabled);
    }
    public V1beta1CustomResourceValidationBuilder(V1beta1CustomResourceValidationFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1CustomResourceValidationBuilder(V1beta1CustomResourceValidationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1CustomResourceValidation(), validationEnabled);
    }
    public V1beta1CustomResourceValidationBuilder(V1beta1CustomResourceValidationFluent<?> fluent,V1beta1CustomResourceValidation instance){
            this(fluent, instance, true);
    }
    public V1beta1CustomResourceValidationBuilder(V1beta1CustomResourceValidationFluent<?> fluent,V1beta1CustomResourceValidation instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1CustomResourceValidationBuilder(V1beta1CustomResourceValidation instance){
            this(instance,true);
    }
    public V1beta1CustomResourceValidationBuilder(V1beta1CustomResourceValidation instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1CustomResourceValidation build(){
            V1beta1CustomResourceValidation buildable = new V1beta1CustomResourceValidation();
            buildable.setOpenAPIV3Schema(fluent.getOpenAPIV3Schema());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CustomResourceValidationBuilder that = (V1beta1CustomResourceValidationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
