package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServicePortBuilder extends V1ServicePortFluentImpl<V1ServicePortBuilder> implements VisitableBuilder<V1ServicePort,V1ServicePortBuilder>{

    V1ServicePortFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServicePortBuilder(){
            this(true);
    }
    public V1ServicePortBuilder(Boolean validationEnabled){
            this(new V1ServicePort(), validationEnabled);
    }
    public V1ServicePortBuilder(V1ServicePortFluent<?> fluent){
            this(fluent, true);
    }
    public V1ServicePortBuilder(V1ServicePortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ServicePort(), validationEnabled);
    }
    public V1ServicePortBuilder(V1ServicePortFluent<?> fluent,V1ServicePort instance){
            this(fluent, instance, true);
    }
    public V1ServicePortBuilder(V1ServicePortFluent<?> fluent,V1ServicePort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withNodePort(instance.getNodePort());

            fluent.withPort(instance.getPort());

            fluent.withProtocol(instance.getProtocol());

            fluent.withTargetPort(instance.getTargetPort());

            this.validationEnabled = validationEnabled; 
    }
    public V1ServicePortBuilder(V1ServicePort instance){
            this(instance,true);
    }
    public V1ServicePortBuilder(V1ServicePort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withNodePort(instance.getNodePort());

            this.withPort(instance.getPort());

            this.withProtocol(instance.getProtocol());

            this.withTargetPort(instance.getTargetPort());

            this.validationEnabled = validationEnabled; 
    }

    public V1ServicePort build(){
            V1ServicePort buildable = new V1ServicePort();
            buildable.setName(fluent.getName());
            buildable.setNodePort(fluent.getNodePort());
            buildable.setPort(fluent.getPort());
            buildable.setProtocol(fluent.getProtocol());
            buildable.setTargetPort(fluent.getTargetPort());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ServicePortBuilder that = (V1ServicePortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
