package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1DeploymentListBuilder extends AppsV1beta1DeploymentListFluentImpl<AppsV1beta1DeploymentListBuilder> implements VisitableBuilder<AppsV1beta1DeploymentList,AppsV1beta1DeploymentListBuilder>{

    AppsV1beta1DeploymentListFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1DeploymentListBuilder(){
            this(true);
    }
    public AppsV1beta1DeploymentListBuilder(Boolean validationEnabled){
            this(new AppsV1beta1DeploymentList(), validationEnabled);
    }
    public AppsV1beta1DeploymentListBuilder(AppsV1beta1DeploymentListFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1DeploymentListBuilder(AppsV1beta1DeploymentListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1DeploymentList(), validationEnabled);
    }
    public AppsV1beta1DeploymentListBuilder(AppsV1beta1DeploymentListFluent<?> fluent,AppsV1beta1DeploymentList instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1DeploymentListBuilder(AppsV1beta1DeploymentListFluent<?> fluent,AppsV1beta1DeploymentList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1DeploymentListBuilder(AppsV1beta1DeploymentList instance){
            this(instance,true);
    }
    public AppsV1beta1DeploymentListBuilder(AppsV1beta1DeploymentList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1DeploymentList build(){
            AppsV1beta1DeploymentList buildable = new AppsV1beta1DeploymentList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1DeploymentListBuilder that = (AppsV1beta1DeploymentListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
