/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V2beta1HorizontalPodAutoscalerSpec;
import io.kubernetes.client.models.V2beta1HorizontalPodAutoscalerStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.")
public class V2beta1HorizontalPodAutoscaler {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="spec")
    private V2beta1HorizontalPodAutoscalerSpec spec = null;
    @SerializedName(value="status")
    private V2beta1HorizontalPodAutoscalerStatus status = null;

    public V2beta1HorizontalPodAutoscaler apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V2beta1HorizontalPodAutoscaler kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V2beta1HorizontalPodAutoscaler metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V2beta1HorizontalPodAutoscaler spec(V2beta1HorizontalPodAutoscalerSpec spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(value="spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.")
    public V2beta1HorizontalPodAutoscalerSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V2beta1HorizontalPodAutoscalerSpec spec) {
        this.spec = spec;
    }

    public V2beta1HorizontalPodAutoscaler status(V2beta1HorizontalPodAutoscalerStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="status is the current information about the autoscaler.")
    public V2beta1HorizontalPodAutoscalerStatus getStatus() {
        return this.status;
    }

    public void setStatus(V2beta1HorizontalPodAutoscalerStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1HorizontalPodAutoscaler v2beta1HorizontalPodAutoscaler = (V2beta1HorizontalPodAutoscaler)o;
        return Objects.equals(this.apiVersion, v2beta1HorizontalPodAutoscaler.apiVersion) && Objects.equals(this.kind, v2beta1HorizontalPodAutoscaler.kind) && Objects.equals(this.metadata, v2beta1HorizontalPodAutoscaler.metadata) && Objects.equals(this.spec, v2beta1HorizontalPodAutoscaler.spec) && Objects.equals(this.status, v2beta1HorizontalPodAutoscaler.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1HorizontalPodAutoscaler {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

