/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.AdmissionregistrationV1beta1ServiceReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="WebhookClientConfig contains the information to make a TLS connection with the webhook")
public class V1beta1WebhookClientConfig {
    @SerializedName(value="caBundle")
    private byte[] caBundle = null;
    @SerializedName(value="service")
    private AdmissionregistrationV1beta1ServiceReference service = null;
    @SerializedName(value="url")
    private String url = null;

    public V1beta1WebhookClientConfig caBundle(byte[] caBundle) {
        this.caBundle = caBundle;
        return this;
    }

    @ApiModelProperty(required=true, value="`caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. Required.")
    public byte[] getCaBundle() {
        return this.caBundle;
    }

    public void setCaBundle(byte[] caBundle) {
        this.caBundle = caBundle;
    }

    public V1beta1WebhookClientConfig service(AdmissionregistrationV1beta1ServiceReference service) {
        this.service = service;
        return this;
    }

    @ApiModelProperty(value="`service` is a reference to the service for this webhook. Either `service` or `url` must be specified.  If the webhook is running within the cluster, then you should use `service`.  Port 443 will be used if it is open, otherwise it is an error.")
    public AdmissionregistrationV1beta1ServiceReference getService() {
        return this.service;
    }

    public void setService(AdmissionregistrationV1beta1ServiceReference service) {
        this.service = service;
    }

    public V1beta1WebhookClientConfig url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="`url` gives the location of the webhook, in standard URL form (`[scheme://]host:port/path`). Exactly one of `url` or `service` must be specified.  The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.  Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.  The scheme must be \"https\"; the URL must begin with \"https://\".  A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.  Attempting to use a user or basic auth e.g. \"user:password@\" is not allowed. Fragments (\"#...\") and query parameters (\"?...\") are not allowed, either.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1WebhookClientConfig v1beta1WebhookClientConfig = (V1beta1WebhookClientConfig)o;
        return Objects.equals(this.caBundle, v1beta1WebhookClientConfig.caBundle) && Objects.equals(this.service, v1beta1WebhookClientConfig.service) && Objects.equals(this.url, v1beta1WebhookClientConfig.url);
    }

    public int hashCode() {
        return Objects.hash(this.caBundle, this.service, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1WebhookClientConfig {\n");
        sb.append("    caBundle: ").append(this.toIndentedString(this.caBundle)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

