/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1beta1PolicyRule;
import io.kubernetes.client.models.V1beta1PolicyRuleBuilder;
import io.kubernetes.client.models.V1beta1PolicyRuleFluentImpl;
import io.kubernetes.client.models.V1beta1Role;
import io.kubernetes.client.models.V1beta1RoleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1beta1RoleFluentImpl<A extends V1beta1RoleFluent<A>>
extends BaseFluent<A>
implements V1beta1RoleFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<V1beta1PolicyRuleBuilder> rules;

    public V1beta1RoleFluentImpl() {
    }

    public V1beta1RoleFluentImpl(V1beta1Role instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1beta1RoleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1beta1RoleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1beta1RoleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1beta1RoleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1beta1RoleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRules(int index, V1beta1PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1beta1PolicyRuleBuilder>();
        }
        V1beta1PolicyRuleBuilder builder = new V1beta1PolicyRuleBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, V1beta1PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1beta1PolicyRuleBuilder>();
        }
        V1beta1PolicyRuleBuilder builder = new V1beta1PolicyRuleBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(V1beta1PolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1beta1PolicyRuleBuilder>();
        }
        for (V1beta1PolicyRule item : items) {
            V1beta1PolicyRuleBuilder builder = new V1beta1PolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<V1beta1PolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1beta1PolicyRuleBuilder>();
        }
        for (V1beta1PolicyRule item : items) {
            V1beta1PolicyRuleBuilder builder = new V1beta1PolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(V1beta1PolicyRule ... items) {
        for (V1beta1PolicyRule item : items) {
            V1beta1PolicyRuleBuilder builder = new V1beta1PolicyRuleBuilder(item);
            this._visitables.remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<V1beta1PolicyRule> items) {
        for (V1beta1PolicyRule item : items) {
            V1beta1PolicyRuleBuilder builder = new V1beta1PolicyRuleBuilder(item);
            this._visitables.remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1beta1PolicyRule> getRules() {
        return V1beta1RoleFluentImpl.build(this.rules);
    }

    @Override
    public List<V1beta1PolicyRule> buildRules() {
        return V1beta1RoleFluentImpl.build(this.rules);
    }

    @Override
    public V1beta1PolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public V1beta1PolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public V1beta1PolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public V1beta1PolicyRule buildMatchingRule(Predicate<V1beta1PolicyRuleBuilder> predicate) {
        for (V1beta1PolicyRuleBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRules(List<V1beta1PolicyRule> rules) {
        if (this.rules != null) {
            this._visitables.removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<V1beta1PolicyRuleBuilder>();
            for (V1beta1PolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(V1beta1PolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (V1beta1PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public V1beta1RoleFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public V1beta1RoleFluent.RulesNested<A> addNewRuleLike(V1beta1PolicyRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public V1beta1RoleFluent.RulesNested<A> setNewRuleLike(int index, V1beta1PolicyRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public V1beta1RoleFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1beta1RoleFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public V1beta1RoleFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1beta1RoleFluent.RulesNested<A> editMatchingRule(Predicate<V1beta1PolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.apply(this.rules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1RoleFluentImpl that = (V1beta1RoleFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public class RulesNestedImpl<N>
    extends V1beta1PolicyRuleFluentImpl<V1beta1RoleFluent.RulesNested<N>>
    implements V1beta1RoleFluent.RulesNested<N>,
    Nested<N> {
        private final V1beta1PolicyRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, V1beta1PolicyRule item) {
            this.index = index;
            this.builder = new V1beta1PolicyRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1PolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1RoleFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1beta1RoleFluent.MetadataNested<N>>
    implements V1beta1RoleFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1RoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

