/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1beta1APIService;
import io.kubernetes.client.models.V1beta1APIServiceFluent;
import io.kubernetes.client.models.V1beta1APIServiceSpec;
import io.kubernetes.client.models.V1beta1APIServiceSpecBuilder;
import io.kubernetes.client.models.V1beta1APIServiceSpecFluentImpl;
import io.kubernetes.client.models.V1beta1APIServiceStatus;
import io.kubernetes.client.models.V1beta1APIServiceStatusBuilder;
import io.kubernetes.client.models.V1beta1APIServiceStatusFluentImpl;

public class V1beta1APIServiceFluentImpl<A extends V1beta1APIServiceFluent<A>>
extends BaseFluent<A>
implements V1beta1APIServiceFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1beta1APIServiceSpecBuilder spec;
    private V1beta1APIServiceStatusBuilder status;

    public V1beta1APIServiceFluentImpl() {
    }

    public V1beta1APIServiceFluentImpl(V1beta1APIService instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1beta1APIServiceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1beta1APIServiceFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1beta1APIServiceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1beta1APIServiceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1beta1APIServiceFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1beta1APIServiceSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1beta1APIServiceSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1beta1APIServiceSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new V1beta1APIServiceSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V1beta1APIServiceFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V1beta1APIServiceFluent.SpecNested<A> withNewSpecLike(V1beta1APIServiceSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V1beta1APIServiceFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V1beta1APIServiceFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1beta1APIServiceSpecBuilder().build());
    }

    @Override
    public V1beta1APIServiceFluent.SpecNested<A> editOrNewSpecLike(V1beta1APIServiceSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1beta1APIServiceStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1beta1APIServiceStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1beta1APIServiceStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new V1beta1APIServiceStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1beta1APIServiceFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1beta1APIServiceFluent.StatusNested<A> withNewStatusLike(V1beta1APIServiceStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1beta1APIServiceFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1beta1APIServiceFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1beta1APIServiceStatusBuilder().build());
    }

    @Override
    public V1beta1APIServiceFluent.StatusNested<A> editOrNewStatusLike(V1beta1APIServiceStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1APIServiceFluentImpl that = (V1beta1APIServiceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends V1beta1APIServiceStatusFluentImpl<V1beta1APIServiceFluent.StatusNested<N>>
    implements V1beta1APIServiceFluent.StatusNested<N>,
    Nested<N> {
        private final V1beta1APIServiceStatusBuilder builder;

        StatusNestedImpl(V1beta1APIServiceStatus item) {
            this.builder = new V1beta1APIServiceStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1beta1APIServiceStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1APIServiceFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends V1beta1APIServiceSpecFluentImpl<V1beta1APIServiceFluent.SpecNested<N>>
    implements V1beta1APIServiceFluent.SpecNested<N>,
    Nested<N> {
        private final V1beta1APIServiceSpecBuilder builder;

        SpecNestedImpl(V1beta1APIServiceSpec item) {
            this.builder = new V1beta1APIServiceSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1beta1APIServiceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1APIServiceFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1beta1APIServiceFluent.MetadataNested<N>>
    implements V1beta1APIServiceFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1APIServiceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

