/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a StorageOS persistent volume resource.")
public class V1StorageOSPersistentVolumeSource {
    @SerializedName(value="fsType")
    private String fsType = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="secretRef")
    private V1ObjectReference secretRef = null;
    @SerializedName(value="volumeName")
    private String volumeName = null;
    @SerializedName(value="volumeNamespace")
    private String volumeNamespace = null;

    public V1StorageOSPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1StorageOSPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1StorageOSPersistentVolumeSource secretRef(V1ObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @ApiModelProperty(value="SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.")
    public V1ObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1ObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1StorageOSPersistentVolumeSource volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @ApiModelProperty(value="VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public V1StorageOSPersistentVolumeSource volumeNamespace(String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
        return this;
    }

    @ApiModelProperty(value="VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \"default\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.")
    public String getVolumeNamespace() {
        return this.volumeNamespace;
    }

    public void setVolumeNamespace(String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StorageOSPersistentVolumeSource v1StorageOSPersistentVolumeSource = (V1StorageOSPersistentVolumeSource)o;
        return Objects.equals(this.fsType, v1StorageOSPersistentVolumeSource.fsType) && Objects.equals(this.readOnly, v1StorageOSPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, v1StorageOSPersistentVolumeSource.secretRef) && Objects.equals(this.volumeName, v1StorageOSPersistentVolumeSource.volumeName) && Objects.equals(this.volumeNamespace, v1StorageOSPersistentVolumeSource.volumeNamespace);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeName, this.volumeNamespace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StorageOSPersistentVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("    volumeNamespace: ").append(this.toIndentedString(this.volumeNamespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

