/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ResourceFieldSelector represents container resources (cpu, memory) and their output format")
public class V1ResourceFieldSelector {
    @SerializedName(value="containerName")
    private String containerName = null;
    @SerializedName(value="divisor")
    private String divisor = null;
    @SerializedName(value="resource")
    private String resource = null;

    public V1ResourceFieldSelector containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @ApiModelProperty(value="Container name: required for volumes, optional for env vars")
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public V1ResourceFieldSelector divisor(String divisor) {
        this.divisor = divisor;
        return this;
    }

    @ApiModelProperty(value="Specifies the output format of the exposed resources, defaults to \"1\"")
    public String getDivisor() {
        return this.divisor;
    }

    public void setDivisor(String divisor) {
        this.divisor = divisor;
    }

    public V1ResourceFieldSelector resource(String resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(required=true, value="Required: resource to select")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceFieldSelector v1ResourceFieldSelector = (V1ResourceFieldSelector)o;
        return Objects.equals(this.containerName, v1ResourceFieldSelector.containerName) && Objects.equals(this.divisor, v1ResourceFieldSelector.divisor) && Objects.equals(this.resource, v1ResourceFieldSelector.resource);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.divisor, this.resource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceFieldSelector {\n");
        sb.append("    containerName: ").append(this.toIndentedString(this.containerName)).append("\n");
        sb.append("    divisor: ").append(this.toIndentedString(this.divisor)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

