/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ReplicaSetSpec;
import io.kubernetes.client.models.V1ReplicaSetStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ReplicaSet ensures that a specified number of pod replicas are running at any given time.")
public class V1ReplicaSet {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="spec")
    private V1ReplicaSetSpec spec = null;
    @SerializedName(value="status")
    private V1ReplicaSetStatus status = null;

    public V1ReplicaSet apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ReplicaSet kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ReplicaSet metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1ReplicaSet spec(V1ReplicaSetSpec spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(value="Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status")
    public V1ReplicaSetSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1ReplicaSetSpec spec) {
        this.spec = spec;
    }

    public V1ReplicaSet status(V1ReplicaSetStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status")
    public V1ReplicaSetStatus getStatus() {
        return this.status;
    }

    public void setStatus(V1ReplicaSetStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicaSet v1ReplicaSet = (V1ReplicaSet)o;
        return Objects.equals(this.apiVersion, v1ReplicaSet.apiVersion) && Objects.equals(this.kind, v1ReplicaSet.kind) && Objects.equals(this.metadata, v1ReplicaSet.metadata) && Objects.equals(this.spec, v1ReplicaSet.spec) && Objects.equals(this.status, v1ReplicaSet.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ReplicaSet {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

