/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1NodeConfigSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.")
public class V1NodeConfigStatus {
    @SerializedName(value="active")
    private V1NodeConfigSource active = null;
    @SerializedName(value="assigned")
    private V1NodeConfigSource assigned = null;
    @SerializedName(value="error")
    private String error = null;
    @SerializedName(value="lastKnownGood")
    private V1NodeConfigSource lastKnownGood = null;

    public V1NodeConfigStatus active(V1NodeConfigSource active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.")
    public V1NodeConfigSource getActive() {
        return this.active;
    }

    public void setActive(V1NodeConfigSource active) {
        this.active = active;
    }

    public V1NodeConfigStatus assigned(V1NodeConfigSource assigned) {
        this.assigned = assigned;
        return this;
    }

    @ApiModelProperty(value="Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.")
    public V1NodeConfigSource getAssigned() {
        return this.assigned;
    }

    public void setAssigned(V1NodeConfigSource assigned) {
        this.assigned = assigned;
    }

    public V1NodeConfigStatus error(String error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public V1NodeConfigStatus lastKnownGood(V1NodeConfigSource lastKnownGood) {
        this.lastKnownGood = lastKnownGood;
        return this;
    }

    @ApiModelProperty(value="LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.")
    public V1NodeConfigSource getLastKnownGood() {
        return this.lastKnownGood;
    }

    public void setLastKnownGood(V1NodeConfigSource lastKnownGood) {
        this.lastKnownGood = lastKnownGood;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeConfigStatus v1NodeConfigStatus = (V1NodeConfigStatus)o;
        return Objects.equals(this.active, v1NodeConfigStatus.active) && Objects.equals(this.assigned, v1NodeConfigStatus.assigned) && Objects.equals(this.error, v1NodeConfigStatus.error) && Objects.equals(this.lastKnownGood, v1NodeConfigStatus.lastKnownGood);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.assigned, this.error, this.lastKnownGood);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeConfigStatus {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    assigned: ").append(this.toIndentedString(this.assigned)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    lastKnownGood: ").append(this.toIndentedString(this.lastKnownGood)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

