/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1Namespace;
import io.kubernetes.client.models.V1NamespaceFluent;
import io.kubernetes.client.models.V1NamespaceSpec;
import io.kubernetes.client.models.V1NamespaceSpecBuilder;
import io.kubernetes.client.models.V1NamespaceSpecFluentImpl;
import io.kubernetes.client.models.V1NamespaceStatus;
import io.kubernetes.client.models.V1NamespaceStatusBuilder;
import io.kubernetes.client.models.V1NamespaceStatusFluentImpl;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;

public class V1NamespaceFluentImpl<A extends V1NamespaceFluent<A>>
extends BaseFluent<A>
implements V1NamespaceFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1NamespaceSpecBuilder spec;
    private V1NamespaceStatusBuilder status;

    public V1NamespaceFluentImpl() {
    }

    public V1NamespaceFluentImpl(V1Namespace instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1NamespaceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1NamespaceFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1NamespaceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1NamespaceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1NamespaceFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1NamespaceSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1NamespaceSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1NamespaceSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new V1NamespaceSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V1NamespaceFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V1NamespaceFluent.SpecNested<A> withNewSpecLike(V1NamespaceSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V1NamespaceFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V1NamespaceFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1NamespaceSpecBuilder().build());
    }

    @Override
    public V1NamespaceFluent.SpecNested<A> editOrNewSpecLike(V1NamespaceSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1NamespaceStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1NamespaceStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1NamespaceStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new V1NamespaceStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1NamespaceFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1NamespaceFluent.StatusNested<A> withNewStatusLike(V1NamespaceStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1NamespaceFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1NamespaceFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1NamespaceStatusBuilder().build());
    }

    @Override
    public V1NamespaceFluent.StatusNested<A> editOrNewStatusLike(V1NamespaceStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NamespaceFluentImpl that = (V1NamespaceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends V1NamespaceStatusFluentImpl<V1NamespaceFluent.StatusNested<N>>
    implements V1NamespaceFluent.StatusNested<N>,
    Nested<N> {
        private final V1NamespaceStatusBuilder builder;

        StatusNestedImpl(V1NamespaceStatus item) {
            this.builder = new V1NamespaceStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1NamespaceStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NamespaceFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends V1NamespaceSpecFluentImpl<V1NamespaceFluent.SpecNested<N>>
    implements V1NamespaceFluent.SpecNested<N>,
    Nested<N> {
        private final V1NamespaceSpecBuilder builder;

        SpecNestedImpl(V1NamespaceSpec item) {
            this.builder = new V1NamespaceSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1NamespaceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NamespaceFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1NamespaceFluent.MetadataNested<N>>
    implements V1NamespaceFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NamespaceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

