/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1LimitRangeItem;
import io.kubernetes.client.models.V1LimitRangeItemBuilder;
import io.kubernetes.client.models.V1LimitRangeItemFluentImpl;
import io.kubernetes.client.models.V1LimitRangeSpec;
import io.kubernetes.client.models.V1LimitRangeSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1LimitRangeSpecFluentImpl<A extends V1LimitRangeSpecFluent<A>>
extends BaseFluent<A>
implements V1LimitRangeSpecFluent<A> {
    private List<V1LimitRangeItemBuilder> limits;

    public V1LimitRangeSpecFluentImpl() {
    }

    public V1LimitRangeSpecFluentImpl(V1LimitRangeSpec instance) {
        this.withLimits(instance.getLimits());
    }

    @Override
    public A addToLimits(int index, V1LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList<V1LimitRangeItemBuilder>();
        }
        V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.limits.add(index >= 0 ? index : this.limits.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLimits(int index, V1LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList<V1LimitRangeItemBuilder>();
        }
        V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.limits.size()) {
            this.limits.add(builder);
        } else {
            this.limits.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLimits(V1LimitRangeItem ... items) {
        if (this.limits == null) {
            this.limits = new ArrayList<V1LimitRangeItemBuilder>();
        }
        for (V1LimitRangeItem item : items) {
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            this._visitables.add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLimits(Collection<V1LimitRangeItem> items) {
        if (this.limits == null) {
            this.limits = new ArrayList<V1LimitRangeItemBuilder>();
        }
        for (V1LimitRangeItem item : items) {
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            this._visitables.add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(V1LimitRangeItem ... items) {
        for (V1LimitRangeItem item : items) {
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            this._visitables.remove(builder);
            if (this.limits == null) continue;
            this.limits.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLimits(Collection<V1LimitRangeItem> items) {
        for (V1LimitRangeItem item : items) {
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            this._visitables.remove(builder);
            if (this.limits == null) continue;
            this.limits.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1LimitRangeItem> getLimits() {
        return V1LimitRangeSpecFluentImpl.build(this.limits);
    }

    @Override
    public List<V1LimitRangeItem> buildLimits() {
        return V1LimitRangeSpecFluentImpl.build(this.limits);
    }

    @Override
    public V1LimitRangeItem buildLimit(int index) {
        return this.limits.get(index).build();
    }

    @Override
    public V1LimitRangeItem buildFirstLimit() {
        return this.limits.get(0).build();
    }

    @Override
    public V1LimitRangeItem buildLastLimit() {
        return this.limits.get(this.limits.size() - 1).build();
    }

    @Override
    public V1LimitRangeItem buildMatchingLimit(Predicate<V1LimitRangeItemBuilder> predicate) {
        for (V1LimitRangeItemBuilder item : this.limits) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withLimits(List<V1LimitRangeItem> limits) {
        if (this.limits != null) {
            this._visitables.removeAll(this.limits);
        }
        if (limits != null) {
            this.limits = new ArrayList<V1LimitRangeItemBuilder>();
            for (V1LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        } else {
            this.limits = null;
        }
        return (A)this;
    }

    @Override
    public A withLimits(V1LimitRangeItem ... limits) {
        if (this.limits != null) {
            this.limits.clear();
        }
        if (limits != null) {
            for (V1LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLimits() {
        return this.limits != null && !this.limits.isEmpty();
    }

    @Override
    public V1LimitRangeSpecFluent.LimitsNested<A> addNewLimit() {
        return new LimitsNestedImpl();
    }

    @Override
    public V1LimitRangeSpecFluent.LimitsNested<A> addNewLimitLike(V1LimitRangeItem item) {
        return new LimitsNestedImpl(-1, item);
    }

    @Override
    public V1LimitRangeSpecFluent.LimitsNested<A> setNewLimitLike(int index, V1LimitRangeItem item) {
        return new LimitsNestedImpl(index, item);
    }

    @Override
    public V1LimitRangeSpecFluent.LimitsNested<A> editLimit(int index) {
        if (this.limits.size() <= index) {
            throw new RuntimeException("Can't edit limits. Index exceeds size.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    @Override
    public V1LimitRangeSpecFluent.LimitsNested<A> editFirstLimit() {
        if (this.limits.size() == 0) {
            throw new RuntimeException("Can't edit first limits. The list is empty.");
        }
        return this.setNewLimitLike(0, this.buildLimit(0));
    }

    @Override
    public V1LimitRangeSpecFluent.LimitsNested<A> editLastLimit() {
        int index = this.limits.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last limits. The list is empty.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    @Override
    public V1LimitRangeSpecFluent.LimitsNested<A> editMatchingLimit(Predicate<V1LimitRangeItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.limits.size(); ++i) {
            if (!predicate.apply(this.limits.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching limits. No match found.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1LimitRangeSpecFluentImpl that = (V1LimitRangeSpecFluentImpl)o;
        return !(this.limits != null ? !this.limits.equals(that.limits) : that.limits != null);
    }

    public class LimitsNestedImpl<N>
    extends V1LimitRangeItemFluentImpl<V1LimitRangeSpecFluent.LimitsNested<N>>
    implements V1LimitRangeSpecFluent.LimitsNested<N>,
    Nested<N> {
        private final V1LimitRangeItemBuilder builder;
        private final int index;

        LimitsNestedImpl(int index, V1LimitRangeItem item) {
            this.index = index;
            this.builder = new V1LimitRangeItemBuilder(this, item);
        }

        LimitsNestedImpl() {
            this.index = -1;
            this.builder = new V1LimitRangeItemBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1LimitRangeSpecFluentImpl.this.setToLimits(this.index, this.builder.build());
        }

        @Override
        public N endLimit() {
            return this.and();
        }
    }
}

