/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1CrossVersionObjectReference;
import io.kubernetes.client.models.V1CrossVersionObjectReferenceBuilder;
import io.kubernetes.client.models.V1CrossVersionObjectReferenceFluentImpl;
import io.kubernetes.client.models.V1HorizontalPodAutoscalerSpec;
import io.kubernetes.client.models.V1HorizontalPodAutoscalerSpecFluent;

public class V1HorizontalPodAutoscalerSpecFluentImpl<A extends V1HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements V1HorizontalPodAutoscalerSpecFluent<A> {
    private Integer maxReplicas;
    private Integer minReplicas;
    private V1CrossVersionObjectReferenceBuilder scaleTargetRef;
    private Integer targetCPUUtilizationPercentage;

    public V1HorizontalPodAutoscalerSpecFluentImpl() {
    }

    public V1HorizontalPodAutoscalerSpecFluentImpl(V1HorizontalPodAutoscalerSpec instance) {
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
        this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    @Override
    public A withNewMaxReplicas(int arg1) {
        return this.withMaxReplicas(new Integer(arg1));
    }

    @Override
    public A withNewMaxReplicas(String arg1) {
        return this.withMaxReplicas(new Integer(arg1));
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    @Override
    public A withNewMinReplicas(int arg1) {
        return this.withMinReplicas(new Integer(arg1));
    }

    @Override
    public A withNewMinReplicas(String arg1) {
        return this.withMinReplicas(new Integer(arg1));
    }

    @Override
    @Deprecated
    public V1CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public V1CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public A withScaleTargetRef(V1CrossVersionObjectReference scaleTargetRef) {
        this._visitables.remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new V1CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.add(this.scaleTargetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    @Override
    public V1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNestedImpl();
    }

    @Override
    public V1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(V1CrossVersionObjectReference item) {
        return new ScaleTargetRefNestedImpl(item);
    }

    @Override
    public V1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef());
    }

    @Override
    public V1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : new V1CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public V1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(V1CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : item);
    }

    @Override
    public Integer getTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage;
    }

    @Override
    public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
        return (A)this;
    }

    @Override
    public Boolean hasTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage != null;
    }

    @Override
    public A withNewTargetCPUUtilizationPercentage(int arg1) {
        return this.withTargetCPUUtilizationPercentage(new Integer(arg1));
    }

    @Override
    public A withNewTargetCPUUtilizationPercentage(String arg1) {
        return this.withTargetCPUUtilizationPercentage(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HorizontalPodAutoscalerSpecFluentImpl that = (V1HorizontalPodAutoscalerSpecFluentImpl)o;
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        if (this.scaleTargetRef != null ? !this.scaleTargetRef.equals(that.scaleTargetRef) : that.scaleTargetRef != null) {
            return false;
        }
        return !(this.targetCPUUtilizationPercentage != null ? !this.targetCPUUtilizationPercentage.equals(that.targetCPUUtilizationPercentage) : that.targetCPUUtilizationPercentage != null);
    }

    public class ScaleTargetRefNestedImpl<N>
    extends V1CrossVersionObjectReferenceFluentImpl<V1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>>
    implements V1HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,
    Nested<N> {
        private final V1CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNestedImpl(V1CrossVersionObjectReference item) {
            this.builder = new V1CrossVersionObjectReferenceBuilder(this, item);
        }

        ScaleTargetRefNestedImpl() {
            this.builder = new V1CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(this.builder.build());
        }

        @Override
        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

