/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.")
public class V1FCVolumeSource {
    @SerializedName(value="fsType")
    private String fsType = null;
    @SerializedName(value="lun")
    private Integer lun = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="targetWWNs")
    private List<String> targetWWNs = null;
    @SerializedName(value="wwids")
    private List<String> wwids = null;

    public V1FCVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1FCVolumeSource lun(Integer lun) {
        this.lun = lun;
        return this;
    }

    @ApiModelProperty(value="Optional: FC target lun number")
    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public V1FCVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1FCVolumeSource targetWWNs(List<String> targetWWNs) {
        this.targetWWNs = targetWWNs;
        return this;
    }

    public V1FCVolumeSource addTargetWWNsItem(String targetWWNsItem) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.add(targetWWNsItem);
        return this;
    }

    @ApiModelProperty(value="Optional: FC target worldwide names (WWNs)")
    public List<String> getTargetWWNs() {
        return this.targetWWNs;
    }

    public void setTargetWWNs(List<String> targetWWNs) {
        this.targetWWNs = targetWWNs;
    }

    public V1FCVolumeSource wwids(List<String> wwids) {
        this.wwids = wwids;
        return this;
    }

    public V1FCVolumeSource addWwidsItem(String wwidsItem) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.add(wwidsItem);
        return this;
    }

    @ApiModelProperty(value="Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.")
    public List<String> getWwids() {
        return this.wwids;
    }

    public void setWwids(List<String> wwids) {
        this.wwids = wwids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1FCVolumeSource v1FCVolumeSource = (V1FCVolumeSource)o;
        return Objects.equals(this.fsType, v1FCVolumeSource.fsType) && Objects.equals(this.lun, v1FCVolumeSource.lun) && Objects.equals(this.readOnly, v1FCVolumeSource.readOnly) && Objects.equals(this.targetWWNs, v1FCVolumeSource.targetWWNs) && Objects.equals(this.wwids, v1FCVolumeSource.wwids);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.lun, this.readOnly, this.targetWWNs, this.wwids);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1FCVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    lun: ").append(this.toIndentedString(this.lun)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    targetWWNs: ").append(this.toIndentedString(this.targetWWNs)).append("\n");
        sb.append("    wwids: ").append(this.toIndentedString(this.wwids)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

