/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.")
public class V1AzureDiskVolumeSource {
    @SerializedName(value="cachingMode")
    private String cachingMode = null;
    @SerializedName(value="diskName")
    private String diskName = null;
    @SerializedName(value="diskURI")
    private String diskURI = null;
    @SerializedName(value="fsType")
    private String fsType = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;

    public V1AzureDiskVolumeSource cachingMode(String cachingMode) {
        this.cachingMode = cachingMode;
        return this;
    }

    @ApiModelProperty(value="Host Caching mode: None, Read Only, Read Write.")
    public String getCachingMode() {
        return this.cachingMode;
    }

    public void setCachingMode(String cachingMode) {
        this.cachingMode = cachingMode;
    }

    public V1AzureDiskVolumeSource diskName(String diskName) {
        this.diskName = diskName;
        return this;
    }

    @ApiModelProperty(required=true, value="The Name of the data disk in the blob storage")
    public String getDiskName() {
        return this.diskName;
    }

    public void setDiskName(String diskName) {
        this.diskName = diskName;
    }

    public V1AzureDiskVolumeSource diskURI(String diskURI) {
        this.diskURI = diskURI;
        return this;
    }

    @ApiModelProperty(required=true, value="The URI the data disk in the blob storage")
    public String getDiskURI() {
        return this.diskURI;
    }

    public void setDiskURI(String diskURI) {
        this.diskURI = diskURI;
    }

    public V1AzureDiskVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1AzureDiskVolumeSource kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1AzureDiskVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AzureDiskVolumeSource v1AzureDiskVolumeSource = (V1AzureDiskVolumeSource)o;
        return Objects.equals(this.cachingMode, v1AzureDiskVolumeSource.cachingMode) && Objects.equals(this.diskName, v1AzureDiskVolumeSource.diskName) && Objects.equals(this.diskURI, v1AzureDiskVolumeSource.diskURI) && Objects.equals(this.fsType, v1AzureDiskVolumeSource.fsType) && Objects.equals(this.kind, v1AzureDiskVolumeSource.kind) && Objects.equals(this.readOnly, v1AzureDiskVolumeSource.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.cachingMode, this.diskName, this.diskURI, this.fsType, this.kind, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AzureDiskVolumeSource {\n");
        sb.append("    cachingMode: ").append(this.toIndentedString(this.cachingMode)).append("\n");
        sb.append("    diskName: ").append(this.toIndentedString(this.diskName)).append("\n");
        sb.append("    diskURI: ").append(this.toIndentedString(this.diskURI)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

