/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NonResourceAttributes;
import io.kubernetes.client.openapi.models.V1ResourceAttributes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set")
public class V1SubjectAccessReviewSpec {
    public static final String SERIALIZED_NAME_EXTRA = "extra";
    @SerializedName(value="extra")
    @Nullable
    private Map<String, List<String>> extra = new HashMap<String, List<String>>();
    public static final String SERIALIZED_NAME_GROUPS = "groups";
    @SerializedName(value="groups")
    @Nullable
    private List<String> groups = new ArrayList<String>();
    public static final String SERIALIZED_NAME_NON_RESOURCE_ATTRIBUTES = "nonResourceAttributes";
    @SerializedName(value="nonResourceAttributes")
    @Nullable
    private V1NonResourceAttributes nonResourceAttributes;
    public static final String SERIALIZED_NAME_RESOURCE_ATTRIBUTES = "resourceAttributes";
    @SerializedName(value="resourceAttributes")
    @Nullable
    private V1ResourceAttributes resourceAttributes;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    @Nullable
    private String uid;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    @Nullable
    private String user;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1SubjectAccessReviewSpec extra(@Nullable Map<String, List<String>> extra) {
        this.extra = extra;
        return this;
    }

    public V1SubjectAccessReviewSpec putExtraItem(String key, List<String> extraItem) {
        if (this.extra == null) {
            this.extra = new HashMap<String, List<String>>();
        }
        this.extra.put(key, extraItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.")
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public void setExtra(@Nullable Map<String, List<String>> extra) {
        this.extra = extra;
    }

    public V1SubjectAccessReviewSpec groups(@Nullable List<String> groups) {
        this.groups = groups;
        return this;
    }

    public V1SubjectAccessReviewSpec addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Groups is the groups you're testing for.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(@Nullable List<String> groups) {
        this.groups = groups;
    }

    public V1SubjectAccessReviewSpec nonResourceAttributes(@Nullable V1NonResourceAttributes nonResourceAttributes) {
        this.nonResourceAttributes = nonResourceAttributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NonResourceAttributes getNonResourceAttributes() {
        return this.nonResourceAttributes;
    }

    public void setNonResourceAttributes(@Nullable V1NonResourceAttributes nonResourceAttributes) {
        this.nonResourceAttributes = nonResourceAttributes;
    }

    public V1SubjectAccessReviewSpec resourceAttributes(@Nullable V1ResourceAttributes resourceAttributes) {
        this.resourceAttributes = resourceAttributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes;
    }

    public void setResourceAttributes(@Nullable V1ResourceAttributes resourceAttributes) {
        this.resourceAttributes = resourceAttributes;
    }

    public V1SubjectAccessReviewSpec uid(@Nullable String uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UID information about the requesting user.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(@Nullable String uid) {
        this.uid = uid;
    }

    public V1SubjectAccessReviewSpec user(@Nullable String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User is the user you're testing for. If you specify \"User\" but not \"Groups\", then is it interpreted as \"What if User were not a member of any groups")
    public String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SubjectAccessReviewSpec v1SubjectAccessReviewSpec = (V1SubjectAccessReviewSpec)o;
        return Objects.equals(this.extra, v1SubjectAccessReviewSpec.extra) && Objects.equals(this.groups, v1SubjectAccessReviewSpec.groups) && Objects.equals(this.nonResourceAttributes, v1SubjectAccessReviewSpec.nonResourceAttributes) && Objects.equals(this.resourceAttributes, v1SubjectAccessReviewSpec.resourceAttributes) && Objects.equals(this.uid, v1SubjectAccessReviewSpec.uid) && Objects.equals(this.user, v1SubjectAccessReviewSpec.user);
    }

    public int hashCode() {
        return Objects.hash(this.extra, this.groups, this.nonResourceAttributes, this.resourceAttributes, this.uid, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SubjectAccessReviewSpec {\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    nonResourceAttributes: ").append(this.toIndentedString(this.nonResourceAttributes)).append("\n");
        sb.append("    resourceAttributes: ").append(this.toIndentedString(this.resourceAttributes)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1SubjectAccessReviewSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1SubjectAccessReviewSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `groups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_ATTRIBUTES).isJsonNull()) {
            V1NonResourceAttributes.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_ATTRIBUTES));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_ATTRIBUTES).isJsonNull()) {
            V1ResourceAttributes.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE_ATTRIBUTES));
        }
        if (jsonObj.get(SERIALIZED_NAME_UID) != null && !jsonObj.get(SERIALIZED_NAME_UID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
    }

    public static V1SubjectAccessReviewSpec fromJson(String jsonString) throws IOException {
        return (V1SubjectAccessReviewSpec)JSON.getGson().fromJson(jsonString, V1SubjectAccessReviewSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EXTRA);
        openapiFields.add(SERIALIZED_NAME_GROUPS);
        openapiFields.add(SERIALIZED_NAME_NON_RESOURCE_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_UID);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1SubjectAccessReviewSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1SubjectAccessReviewSpec.class));
            return new TypeAdapter<V1SubjectAccessReviewSpec>(){

                public void write(JsonWriter out, V1SubjectAccessReviewSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1SubjectAccessReviewSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1SubjectAccessReviewSpec.validateJsonElement(jsonElement);
                    return (V1SubjectAccessReviewSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

