/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.bigdecimal;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/kotest/matchers/bigdecimal/ToleranceMatcher;", "Lio/kotest/matchers/Matcher;", "Ljava/math/BigDecimal;", "expected", "tolerance", "<init>", "(Ljava/math/BigDecimal;Ljava/math/BigDecimal;)V", "test", "Lio/kotest/matchers/MatcherResult;", "value", "kotest-assertions-core"})
public final class ToleranceMatcher
implements Matcher<BigDecimal> {
    @Nullable
    private final BigDecimal expected;
    @NotNull
    private final BigDecimal tolerance;

    public ToleranceMatcher(@Nullable BigDecimal expected, @NotNull BigDecimal tolerance) {
        Intrinsics.checkNotNullParameter((Object)tolerance, (String)"tolerance");
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @NotNull
    public MatcherResult test(@Nullable BigDecimal value) {
        MatcherResult matcherResult;
        if (value == null || this.expected == null) {
            matcherResult = MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value, (Object)this.expected), () -> ToleranceMatcher.test$lambda$0(value, this), () -> ToleranceMatcher.test$lambda$1(value, this));
        } else {
            if (Intrinsics.areEqual((Object)this.tolerance, (Object)BigDecimal.ZERO)) {
                System.out.println((Object)"[WARN] When comparing doubles consider using tolerance, eg: a shouldBe (b plusOrMinus c)");
            }
            BigDecimal bigDecimal = value.subtract(this.expected);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"subtract(...)");
            BigDecimal diff = bigDecimal.abs();
            boolean passed = diff.compareTo(this.tolerance) <= 0;
            BigDecimal bigDecimal2 = this.expected.subtract(this.tolerance);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"subtract(...)");
            BigDecimal low = bigDecimal2;
            BigDecimal bigDecimal3 = this.expected.add(this.tolerance);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"add(...)");
            BigDecimal high = bigDecimal3;
            String msg = Intrinsics.areEqual((Object)this.tolerance, (Object)BigDecimal.ZERO) ? value + " should be equal to " + this.expected : value + " should be equal to " + this.expected + " within tolerance of " + this.tolerance + " (lowest acceptable value is " + low + "; highest acceptable value is " + high + ")";
            matcherResult = MatcherResult.Companion.invoke(passed, () -> ToleranceMatcher.test$lambda$2(msg), () -> ToleranceMatcher.test$lambda$3(value, this));
        }
        return matcherResult;
    }

    private static final String test$lambda$0(BigDecimal $value, ToleranceMatcher this$0) {
        return $value + " should be equal to " + this$0.expected;
    }

    private static final String test$lambda$1(BigDecimal $value, ToleranceMatcher this$0) {
        return $value + " should not be equal to " + this$0.expected;
    }

    private static final String test$lambda$2(String $msg) {
        return $msg;
    }

    private static final String test$lambda$3(BigDecimal $value, ToleranceMatcher this$0) {
        return $value + " should not be equal to " + this$0.expected;
    }
}

