/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.doubles;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.doubles.Percentage;
import io.kotest.matchers.doubles.ToleranceKt;
import io.kotest.matchers.doubles.ToleranceMatcher;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0086\u0004\u001a\u001a\u0010\n\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\u001a\u0010\r\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u0010"}, d2={"plusOrMinus", "Lio/kotest/matchers/doubles/ToleranceMatcher;", "", "tolerance", "percent", "Lio/kotest/matchers/doubles/Percentage;", "", "getPercent", "(Ljava/lang/Number;)Lio/kotest/matchers/doubles/Percentage;", "(D)Lio/kotest/matchers/doubles/Percentage;", "shouldBeWithinPercentageOf", "other", "percentage", "shouldNotBeWithinPercentageOf", "beWithinPercentageOf", "Lio/kotest/matchers/Matcher;", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nTolerance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tolerance.kt\nio/kotest/matchers/doubles/ToleranceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class ToleranceKt {
    @NotNull
    public static final ToleranceMatcher plusOrMinus(double $this$plusOrMinus, double tolerance) {
        if (!(tolerance >= 0.0 && Math.abs(tolerance) <= Double.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new ToleranceMatcher($this$plusOrMinus, tolerance);
    }

    @NotNull
    public static final Percentage getPercent(@NotNull Number $this$percent) {
        Intrinsics.checkNotNullParameter((Object)$this$percent, (String)"<this>");
        return ToleranceKt.getPercent($this$percent.doubleValue());
    }

    @NotNull
    public static final Percentage getPercent(double $this$percent) {
        if (!($this$percent >= 0.0 && Math.abs($this$percent) <= Double.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Percentage($this$percent);
    }

    @NotNull
    public static final ToleranceMatcher plusOrMinus(double $this$plusOrMinus, @NotNull Percentage tolerance) {
        Intrinsics.checkNotNullParameter((Object)tolerance, (String)"tolerance");
        double realValue = Math.abs($this$plusOrMinus * tolerance.getValue() / (double)100);
        return new ToleranceMatcher($this$plusOrMinus, realValue);
    }

    public static final double shouldBeWithinPercentageOf(double $this$shouldBeWithinPercentageOf, double other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.should(Double.valueOf($this$shouldBeWithinPercentageOf), ToleranceKt.beWithinPercentageOf(other, percentage));
        return $this$shouldBeWithinPercentageOf;
    }

    public static final double shouldNotBeWithinPercentageOf(double $this$shouldNotBeWithinPercentageOf, double other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.shouldNot($this$shouldNotBeWithinPercentageOf, ToleranceKt.beWithinPercentageOf(other, percentage));
        return $this$shouldNotBeWithinPercentageOf;
    }

    @NotNull
    public static final Matcher<Double> beWithinPercentageOf(double other, double percentage) {
        return (Matcher)new Matcher<Double>(other, percentage){
            private final double tolerance;
            private final ClosedFloatingPointRange<Double> range;
            {
                this.tolerance = Math.abs($other * ($percentage / (double)100));
                this.range = RangesKt.rangeTo((double)($other - this.tolerance), (double)($other + this.tolerance));
            }

            public MatcherResult test(double value) {
                return MatcherResult.Companion.invoke(this.range.contains((Comparable)Double.valueOf(value)), () -> beWithinPercentageOf.1.test$lambda$0(value, this), () -> beWithinPercentageOf.1.test$lambda$1(value, this));
            }

            public Matcher<Double> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, Double> f) {
                return super.contramap(f);
            }

            public Matcher<Double> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(double $value, beWithinPercentageOf.1 this$0) {
                return $value + " should be in " + this$0.range;
            }

            private static final String test$lambda$1(double $value, beWithinPercentageOf.1 this$0) {
                return $value + " should not be in " + this$0.range;
            }
        };
    }
}

