/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="lint", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class LintMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="helm.lint.skip", defaultValue="false")
    private boolean skipLint;
    @Parameter(property="helm.lint.strict", defaultValue="false")
    private boolean lintStrict;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipLint) {
            this.getLog().info((CharSequence)"Skip lint");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)("\n\nTesting chart " + inputDirectory + "..."));
            String arguments = "lint " + inputDirectory + (this.lintStrict ? " --strict" : "") + this.getValuesOptions();
            this.helm(arguments, "There are test failures");
        }
    }

    public LintMojo setSkipLint(boolean skipLint) {
        this.skipLint = skipLint;
        return this;
    }

    public LintMojo setLintStrict(boolean lintStrict) {
        this.lintStrict = lintStrict;
        return this;
    }
}

