/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dry-run", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class DryRunMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="action", defaultValue="install")
    private String action;
    @Parameter(property="helm.dry-run.skip", defaultValue="false")
    private boolean skipDryRun;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipDryRun) {
            this.getLog().info((CharSequence)"Skip dry run");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)("\n\nPerform dry-run for chart " + inputDirectory + "..."));
            String arguments = this.action + " " + inputDirectory + " --dry-run --generate-name" + this.getValuesOptions();
            this.helm(arguments, "There are test failures");
        }
    }

    public DryRunMojo setAction(String action) {
        this.action = action;
        return this;
    }

    public DryRunMojo setSkipDryRun(boolean skipDryRun) {
        this.skipDryRun = skipDryRun;
        return this;
    }
}

