/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic.internal;

import java.time.Year;
import java.util.Objects;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;

public class YearTypeDescriptor
extends AbstractClassJavaType<Year> {
    public static final YearTypeDescriptor INSTANCE = new YearTypeDescriptor();

    public YearTypeDescriptor() {
        super(Year.class);
    }

    public boolean areEqual(Year one, Year another) {
        return Objects.equals(one, another);
    }

    public String toString(Year value) {
        return value.toString();
    }

    public <X> X unwrap(Year value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        if (Number.class.isAssignableFrom(type)) {
            Short numericValue = (short)value.getValue();
            return (X)numericValue;
        }
        throw this.unknownUnwrap(type);
    }

    public <X> Year wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (Year)this.fromString((String)value);
        }
        if (value instanceof Number) {
            short numericValue = ((Number)value).shortValue();
            return Year.of(numericValue);
        }
        throw this.unknownWrap(value.getClass());
    }
}

