/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.writer;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.holunda.camunda.bpm.data.writer.VariableWriter;
import java.util.Objects;
import java.util.function.Function;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.variable.VariableMap;
import org.jetbrains.annotations.NotNull;

public class TaskServiceVariableWriter
implements VariableWriter<TaskServiceVariableWriter> {
    private final TaskService taskService;
    private final String taskId;

    public TaskServiceVariableWriter(TaskService taskService, String taskId) {
        this.taskService = taskService;
        this.taskId = taskId;
    }

    @Override
    @NotNull
    public VariableMap variables() {
        return this.taskService.getVariablesTyped(this.taskId);
    }

    @Override
    @NotNull
    public VariableMap variablesLocal() {
        return this.taskService.getVariablesLocalTyped(this.taskId);
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter set(VariableFactory<T> factory, T value) {
        return this.set((VariableFactory)factory, (Object)value, false);
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter set(VariableFactory<T> factory, T value, boolean isTransient) {
        factory.on(this.taskService, this.taskId).set(value, isTransient);
        return this;
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter setLocal(VariableFactory<T> factory, T value) {
        return this.setLocal((VariableFactory)factory, (Object)value, false);
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter setLocal(VariableFactory<T> factory, T value, boolean isTransient) {
        factory.on(this.taskService, this.taskId).setLocal(value, isTransient);
        return this;
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter remove(VariableFactory<T> factory) {
        factory.on(this.taskService, this.taskId).remove();
        return this;
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter removeLocal(VariableFactory<T> factory) {
        factory.on(this.taskService, this.taskId).removeLocal();
        return this;
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter update(VariableFactory<T> factory, Function<T, T> valueProcessor) {
        factory.on(this.taskService, this.taskId).update(valueProcessor);
        return this;
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter update(VariableFactory<T> factory, Function<T, T> valueProcessor, boolean isTransient) {
        factory.on(this.taskService, this.taskId).update(valueProcessor, isTransient);
        return this;
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter updateLocal(VariableFactory<T> factory, Function<T, T> valueProcessor) {
        factory.on(this.taskService, this.taskId).updateLocal(valueProcessor);
        return this;
    }

    @Override
    @NotNull
    public <T> TaskServiceVariableWriter updateLocal(VariableFactory<T> factory, Function<T, T> valueProcessor, boolean isTransient) {
        factory.on(this.taskService, this.taskId).updateLocal(valueProcessor, isTransient);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskServiceVariableWriter that = (TaskServiceVariableWriter)o;
        if (!Objects.equals(this.taskService, that.taskService)) {
            return false;
        }
        return Objects.equals(this.taskId, that.taskId);
    }

    public int hashCode() {
        int result = this.taskService != null ? this.taskService.hashCode() : 0;
        result = 31 * result + (this.taskId != null ? this.taskId.hashCode() : 0);
        return result;
    }
}

