/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.map;

import io.holunda.camunda.bpm.data.adapter.map.AbstractMapReadWriteAdapter;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.engine.TaskService;

public class MapReadWriteAdapterTaskService<K, V>
extends AbstractMapReadWriteAdapter<K, V> {
    private final TaskService taskService;
    private final String taskId;

    public MapReadWriteAdapterTaskService(TaskService taskService, String taskId, String variableName, Class<K> keyClazz, Class<V> valueClazz) {
        super(variableName, keyClazz, valueClazz);
        this.taskService = taskService;
        this.taskId = taskId;
    }

    @Override
    public Optional<Map<K, V>> getOptional() {
        return Optional.ofNullable(this.getOrNull(this.taskService.getVariable(this.taskId, this.variableName)));
    }

    @Override
    public void set(Map<K, V> value, boolean isTransient) {
        this.taskService.setVariable(this.taskId, this.variableName, (Object)this.getTypedValue(value, isTransient));
    }

    @Override
    public Optional<Map<K, V>> getLocalOptional() {
        return Optional.ofNullable(this.getOrNull(this.taskService.getVariableLocal(this.taskId, this.variableName)));
    }

    @Override
    public void setLocal(Map<K, V> value, boolean isTransient) {
        this.taskService.setVariableLocal(this.taskId, this.variableName, (Object)this.getTypedValue(value, isTransient));
    }

    @Override
    public void remove() {
        this.taskService.removeVariable(this.taskId, this.variableName);
    }

    @Override
    public void removeLocal() {
        this.taskService.removeVariableLocal(this.taskId, this.variableName);
    }
}

