/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.map;

import io.holunda.camunda.bpm.data.adapter.AbstractReadWriteAdapter;
import io.holunda.camunda.bpm.data.adapter.ValueWrapperUtil;
import io.holunda.camunda.bpm.data.adapter.WrongVariableTypeException;
import java.util.Collections;
import java.util.Map;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractMapReadWriteAdapter<K, V>
extends AbstractReadWriteAdapter<Map<K, V>> {
    protected final Class<K> keyClazz;
    protected final Class<V> valueClazz;

    public AbstractMapReadWriteAdapter(String variableName, Class<K> keyClazz, Class<V> valueClazz) {
        super(variableName);
        this.keyClazz = keyClazz;
        this.valueClazz = valueClazz;
    }

    protected Map<K, V> getOrNull(Object value) {
        if (value == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            Map valueAsMap = (Map)value;
            if (valueAsMap.isEmpty()) {
                return Collections.emptyMap();
            }
            Map.Entry entry = valueAsMap.entrySet().iterator().next();
            if (this.keyClazz.isAssignableFrom(entry.getKey().getClass()) && this.valueClazz.isAssignableFrom(entry.getValue().getClass())) {
                return valueAsMap;
            }
            throw new WrongVariableTypeException("Error reading " + this.variableName + ": Wrong map type detected, expected Map<" + this.keyClazz.getName() + "," + this.valueClazz.getName() + ", but was not found in " + valueAsMap);
        }
        throw new WrongVariableTypeException("Error reading " + this.variableName + ": Couldn't read value of type Map from " + value);
    }

    @Override
    public TypedValue getTypedValue(Object value, boolean isTransient) {
        return ValueWrapperUtil.getTypedValue(Map.class, value, isTransient);
    }
}

