/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.jsonp.JsonpBodyWriter;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriterFactory;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

class JsonpBodyStreamWriter
implements MessageBodyStreamWriter<JsonStructure> {
    private static final byte[] ARRAY_JSON_END_BYTES = "]".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ARRAY_JSON_BEGIN_BYTES = "[".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMA_BYTES = ",".getBytes(StandardCharsets.UTF_8);
    private final JsonWriterFactory jsonWriterFactory;

    JsonpBodyStreamWriter(JsonWriterFactory jsonWriterFactory) {
        this.jsonWriterFactory = jsonWriterFactory;
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(JsonStructure.class, type);
    }

    public Multi<DataChunk> write(Flow.Publisher<? extends JsonStructure> publisher, GenericType<? extends JsonStructure> type, MessageBodyWriterContext context) {
        MediaType contentType = context.findAccepted(MediaType.JSON_PREDICATE, MediaType.APPLICATION_JSON);
        context.contentType(contentType);
        AtomicBoolean first = new AtomicBoolean(true);
        JsonpBodyWriter.JsonStructureToChunks jsonToChunks = new JsonpBodyWriter.JsonStructureToChunks(true, this.jsonWriterFactory, context.charset());
        return Multi.create(publisher).map((Function)((Object)jsonToChunks)).flatMap(it -> {
            if (first.getAndSet(false)) {
                return Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])ARRAY_JSON_BEGIN_BYTES), it});
            }
            return Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])COMMA_BYTES), it});
        }).onCompleteResume((Object)DataChunk.create((byte[])ARRAY_JSON_END_BYTES));
    }
}

