/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks;

import com.google.errorprone.annotations.Immutable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

@Immutable
public interface SocketAddressValidator {
    public static final SocketAddressValidator INET = new SocketAddressValidator(){

        @Override
        public boolean isValidSocketAddress(SocketAddress address) {
            return address instanceof InetSocketAddress;
        }

        @Override
        public boolean isValidSocketAddress(String address) {
            return !address.startsWith("unix://");
        }
    };
    public static final SocketAddressValidator UDS = new SocketAddressValidator(){

        @Override
        public boolean isValidSocketAddress(SocketAddress address) {
            return "DomainSocketAddress".equals(address.getClass().getSimpleName());
        }

        @Override
        public boolean isValidSocketAddress(String address) {
            return address.startsWith("unix://");
        }
    };

    public boolean isValidSocketAddress(SocketAddress var1);

    public boolean isValidSocketAddress(String var1);
}

