/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor.scripts;

import com.google.gson.Gson;
import com.t4a.detect.ActionCallback;
import com.t4a.detect.ActionState;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.scripts.LoggingSeleniumCallback;
import com.t4a.processor.scripts.ScriptProcessor;
import com.t4a.processor.scripts.ScriptResult;
import com.t4a.processor.scripts.SeleniumCallback;
import com.t4a.processor.selenium.SeleniumGeminiProcessor;
import com.t4a.processor.selenium.SeleniumProcessor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumScriptProcessor
extends ScriptProcessor {
    private static final Logger log = LoggerFactory.getLogger(SeleniumScriptProcessor.class);
    private Gson gson;
    private SeleniumProcessor seleniumProcessor;

    public SeleniumScriptProcessor() {
        this.gson = new Gson();
        this.seleniumProcessor = new SeleniumGeminiProcessor();
    }

    public SeleniumScriptProcessor(Gson gson) {
        this.gson = gson;
    }

    public SeleniumScriptProcessor(Gson gson, SeleniumProcessor seleniumProcessor) {
        this.gson = gson;
        this.seleniumProcessor = seleniumProcessor;
    }

    public SeleniumScriptProcessor(SeleniumProcessor seleniumProcessor) {
        this.gson = new Gson();
        this.seleniumProcessor = seleniumProcessor;
    }

    @Override
    public ScriptResult process(String fileName) {
        return this.process(fileName, (SeleniumCallback)new LoggingSeleniumCallback());
    }

    public ScriptResult process(String fileName, SeleniumCallback callback) {
        ScriptResult result = new ScriptResult();
        try {
            InputStream is = SeleniumScriptProcessor.class.getClassLoader().getResourceAsStream(fileName);
            if (is == null) {
                is = new FileInputStream(fileName);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                log.debug("Processing script file: " + fileName);
                this.processCommands(reader, result, callback);
            }
        }
        catch (IOException e) {
            log.error("Error processing file: " + e.getMessage());
        }
        catch (AIProcessingException e) {
            log.error("AI Processing error: " + e.getMessage());
        }
        return result;
    }

    public ScriptResult process(StringBuffer content, SeleniumCallback callback) {
        ScriptResult result = new ScriptResult();
        try {
            BufferedReader reader = new BufferedReader(new StringReader(content.toString()));
            log.debug("Processing content from StringBuffer");
            this.processCommands(reader, result, callback);
        }
        catch (IOException e) {
            log.error("Error processing content: " + e.getMessage());
        }
        catch (AIProcessingException e) {
            log.error("AI Processing error: " + e.getMessage());
        }
        return result;
    }

    public ScriptResult process(String content, ActionCallback callback) {
        ScriptResult result = new ScriptResult();
        try {
            BufferedReader reader = new BufferedReader(new StringReader(content));
            log.debug("Processing content string");
            this.processCommands(reader, result, callback);
        }
        catch (IOException e) {
            log.error("Error processing content: " + e.getMessage());
        }
        catch (AIProcessingException e) {
            log.error("AI Processing error: " + e.getMessage());
        }
        return result;
    }

    public void processCommands(BufferedReader reader, ScriptResult result, SeleniumCallback callback) throws IOException, AIProcessingException {
        String line;
        while ((line = reader.readLine()) != null) {
            boolean process = callback.beforeWebAction(line, this.getSeleniumProcessor().getDriver());
            if (process) {
                this.processWebAction(line, callback, 0);
                callback.afterWebAction(line, this.getSeleniumProcessor().getDriver());
            }
            log.debug("{}", (Object)result);
        }
    }

    @Override
    public void processWebAction(String line, SeleniumCallback callback, int retryCount) {
        block2: {
            try {
                this.getSeleniumProcessor().processWebAction(line);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
                String newLine = callback.handleError(line, e.getMessage(), this.getSeleniumProcessor().getDriver(), retryCount);
                if (newLine == null) break block2;
                this.processWebAction(newLine, callback, ++retryCount);
            }
        }
    }

    public void processCommands(BufferedReader reader, ScriptResult result, ActionCallback callback) throws IOException, AIProcessingException {
        String line;
        SeleniumProcessor processor = this.getSeleniumProcessor();
        while ((line = reader.readLine()) != null) {
            callback.sendtStatus("processing " + line, ActionState.WORKING);
            processor.processWebAction(line);
            callback.sendtStatus("processed " + line, ActionState.WORKING);
            log.debug("{}", (Object)result);
        }
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    public SeleniumProcessor getSeleniumProcessor() {
        return this.seleniumProcessor;
    }
}

