/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.action.shell;

import com.t4a.api.ActionType;
import com.t4a.api.PredictedAIAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellPredictedAction
implements PredictedAIAction {
    private static final Logger log = LoggerFactory.getLogger(ShellPredictedAction.class);
    @NonNull
    private String description;
    @NonNull
    private String scriptPath;
    @NonNull
    private String actionName;
    private String parameterNames;
    private String group;
    private String groupDescription;

    public void executeShell(String[] arguments) throws IOException, InterruptedException {
        String line;
        this.scriptPath = this.loadScript(this.scriptPath);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("cmd");
        commandList.add("/c");
        commandList.add(this.scriptPath);
        commandList.addAll(Arrays.asList(arguments));
        ProcessBuilder builder = new ProcessBuilder(commandList);
        log.debug(String.join((CharSequence)" ", commandList));
        Process process = builder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            log.debug(line);
        }
        int exitCode = process.waitFor();
        log.debug("Script exited with code " + exitCode);
    }

    @Override
    public String getActionGroup() {
        return this.group;
    }

    public static String detectPathType(String scriptPath) {
        File file = new File(scriptPath);
        if (file.isAbsolute()) {
            return "Absolute path";
        }
        if (file.getParent() != null) {
            return "Relative path";
        }
        return "Filename only";
    }

    public String loadScript(String scriptPath) {
        File file = new File(scriptPath);
        if (file.isAbsolute()) {
            return this.loadFromAbsolutePath(scriptPath);
        }
        return this.loadFromClasspath(scriptPath);
    }

    public String loadFromAbsolutePath(String absolutePath) {
        File file = new File(absolutePath);
        return file.getAbsolutePath();
    }

    public String loadFromClasspath(String fileName) {
        URL resourceUrl = ShellPredictedAction.class.getClassLoader().getResource(fileName);
        if (resourceUrl != null) {
            File f = null;
            try {
                f = new File(resourceUrl.toURI());
            }
            catch (URISyntaxException e) {
                log.warn(e.getMessage());
            }
            return f.getAbsolutePath();
        }
        return "File not found in classpath: " + fileName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.SHELL;
    }

    public ShellPredictedAction() {
    }

    @NonNull
    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getParameterNames() {
        return this.parameterNames;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupDescription() {
        return this.groupDescription;
    }

    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    public void setScriptPath(@NonNull String scriptPath) {
        if (scriptPath == null) {
            throw new NullPointerException("scriptPath is marked non-null but is null");
        }
        this.scriptPath = scriptPath;
    }

    public void setActionName(@NonNull String actionName) {
        if (actionName == null) {
            throw new NullPointerException("actionName is marked non-null but is null");
        }
        this.actionName = actionName;
    }

    public void setParameterNames(String parameterNames) {
        this.parameterNames = parameterNames;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setGroupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
    }

    public ShellPredictedAction(@NonNull String description, @NonNull String scriptPath, @NonNull String actionName) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (scriptPath == null) {
            throw new NullPointerException("scriptPath is marked non-null but is null");
        }
        if (actionName == null) {
            throw new NullPointerException("actionName is marked non-null but is null");
        }
        this.description = description;
        this.scriptPath = scriptPath;
        this.actionName = actionName;
    }
}

