/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.server;

import com.t4a.api.AIAction;
import com.t4a.api.GenericJavaMethodAction;
import com.t4a.api.GroupInfo;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.transform.GeminiV2PromptTransformer;
import com.t4a.transform.OpenAIPromptTransformer;
import com.t4a.transform.PromptTransformer;
import io.github.vishalmysore.a2a.domain.AgentCard;
import io.github.vishalmysore.a2a.server.A2AAgentCardController;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.ResponseEntity;

public class RealTimeAgentCardController
implements A2AAgentCardController {
    private static final Logger log = Logger.getLogger(RealTimeAgentCardController.class.getName());
    private PromptTransformer promptTransformer;
    public static final String WELL_KNOWN_PATH = "/.well-known/";
    public static final String AGENT_PATH = "/agent.json";
    private AgentCard cachedAgentCard;
    @Value(value="${server.port:8080}")
    private String serverPort;

    public RealTimeAgentCardController() {
        this.promptTransformer = new GeminiV2PromptTransformer();
    }

    public RealTimeAgentCardController(ApplicationContext context) {
        PredictionLoader.getInstance((ApplicationContext)context);
        this.promptTransformer = new GeminiV2PromptTransformer();
    }

    public boolean isMethodAllowed(Method method) {
        return true;
    }

    @Override
    public PromptTransformer getPromptTransformer() {
        return this.promptTransformer;
    }

    @PostConstruct
    public void init() {
        Properties properties = new Properties();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("tools4ai.properties");){
            if (input == null) {
                throw new RuntimeException("Unable to find tools4ai.properties");
            }
            properties.load(input);
            String provider = properties.getProperty("agent.provider");
            if ("openai".equals(provider)) {
                this.promptTransformer = new OpenAIPromptTransformer();
            } else if ("gemini".equals(provider)) {
                this.promptTransformer = new GeminiV2PromptTransformer();
            } else {
                log.info("Provider not found defaulting to Gemini");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file", e);
        }
        Map groupActions = PredictionLoader.getInstance().getActionGroupList().getGroupActions();
        Map predictions = PredictionLoader.getInstance().getPredictions();
        StringBuilder realTimeDescription = new StringBuilder("This agent provides the following capabilities: ");
        for (Map.Entry entry : groupActions.entrySet()) {
            GroupInfo group = (GroupInfo)entry.getKey();
            String[] actionNames = ((String)entry.getValue()).split(",");
            StringBuilder methodNames = new StringBuilder();
            for (String actionName : actionNames) {
                GenericJavaMethodAction methodAction;
                Method m;
                AIAction action = (AIAction)predictions.get(actionName.trim());
                if (!(action instanceof GenericJavaMethodAction) || !this.isMethodAllowed(m = (methodAction = (GenericJavaMethodAction)action).getActionMethod())) continue;
                methodNames.append(",");
                methodNames.append(actionName.trim());
            }
            realTimeDescription.append(group.getGroupName()).append(" (").append(group.getGroupDescription()).append("), with actions: ").append((CharSequence)methodNames).append("; ");
        }
        if (realTimeDescription.length() > 2) {
            realTimeDescription.setLength(realTimeDescription.length() - 2);
        }
        String finalDescription = realTimeDescription.toString();
        try {
            if (groupActions.isEmpty()) {
                log.warning("No actions found for the agent card");
                card = new AgentCard();
                this.storeCard(card);
            } else {
                card = (AgentCard)this.promptTransformer.transformIntoPojo("use this description and also populate skills in detail " + finalDescription, AgentCard.class);
                this.storeCard(card);
            }
            String hostName = InetAddress.getLocalHost().getHostName();
            this.cachedAgentCard.setUrl("http://" + hostName + ":" + this.serverPort);
        }
        catch (AIProcessingException e) {
            log.severe("The skills are not populate in the agent card as actions are more in number \n you can either try with different processor \n or you can populate skills individually and add to agent card , or it could be that AI key is not initialized " + e.getMessage());
        }
        catch (UnknownHostException e) {
            log.warning("host not knwon set the url manually card.setUrl");
        }
    }

    public void storeCard(AgentCard card) {
        this.cachedAgentCard = card;
    }

    @Override
    public ResponseEntity<AgentCard> getAgentCard() {
        return ResponseEntity.ok((Object)this.cachedAgentCard);
    }

    public AgentCard getCachedAgentCard() {
        return this.cachedAgentCard;
    }
}

