/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.vishalmysore.a2a.domain.JsonRpcRequest;
import io.github.vishalmysore.a2a.domain.Message;
import io.github.vishalmysore.a2a.domain.Task;
import io.github.vishalmysore.a2a.domain.TaskCancelParams;
import io.github.vishalmysore.a2a.domain.TaskQueryParams;
import io.github.vishalmysore.a2a.domain.TaskSendParams;
import io.github.vishalmysore.a2a.domain.TextPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class A2ATaskClient {
    private static final Logger log = Logger.getLogger(A2ATaskClient.class.getName());
    private static final String DEFAULT_BASE_URL = "http://localhost:8080/rpc";
    private final String baseUrl;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final List<Task> pendingTasks;
    private final List<Task> completedTasks;

    public A2ATaskClient() {
        this(DEFAULT_BASE_URL);
    }

    public A2ATaskClient(String baseUrl) {
        this.baseUrl = baseUrl;
        this.restTemplate = new RestTemplate();
        this.objectMapper = new ObjectMapper();
        this.pendingTasks = Collections.synchronizedList(new ArrayList());
        this.completedTasks = Collections.synchronizedList(new ArrayList());
    }

    private JsonRpcRequest createRequest(String method, Object params) {
        return new JsonRpcRequest("2.0", method, params, UUID.randomUUID().toString());
    }

    public Task sendTask(String prompt) {
        try {
            Message message = new Message();
            TextPart textPart = new TextPart();
            textPart.setText(prompt);
            message.setParts(Collections.singletonList(textPart));
            TaskSendParams params = new TaskSendParams();
            params.setMessage(message);
            JsonRpcRequest request = this.createRequest("tasks/send", params);
            ResponseEntity response = this.restTemplate.postForEntity(this.baseUrl, (Object)request, Task.class, new Object[0]);
            Task task = (Task)response.getBody();
            if (task != null) {
                this.pendingTasks.add(task);
            }
            return task;
        }
        catch (HttpClientErrorException e) {
            log.severe("Error sending task: " + e.getMessage());
            throw e;
        }
    }

    public Task getTask(String taskId, Integer historyLength) {
        try {
            TaskQueryParams params = new TaskQueryParams();
            params.setId(taskId);
            params.setHistoryLength(historyLength);
            JsonRpcRequest request = this.createRequest("tasks/get", params);
            ResponseEntity response = this.restTemplate.postForEntity(this.baseUrl, (Object)request, Task.class, new Object[0]);
            Task task = (Task)response.getBody();
            if (task != null && task.getStatus().equals("completed")) {
                this.pendingTasks.removeIf(t -> t.getId().equals(taskId));
                this.completedTasks.add(task);
            }
            return task;
        }
        catch (HttpClientErrorException e) {
            log.severe("Error getting task: " + e.getMessage());
            throw e;
        }
    }

    public boolean cancelTask(String taskId) {
        try {
            TaskCancelParams params = new TaskCancelParams();
            params.setId(taskId);
            JsonRpcRequest request = this.createRequest("tasks/cancel", params);
            this.restTemplate.postForEntity(this.baseUrl, (Object)request, Object.class, new Object[0]);
            this.pendingTasks.removeIf(t -> t.getId().equals(taskId));
            return true;
        }
        catch (HttpClientErrorException e) {
            log.severe("Error cancelling task: " + e.getMessage());
            throw e;
        }
    }

    public List<Task> getPendingTasks() {
        return new ArrayList<Task>(this.pendingTasks);
    }

    public List<Task> getCompletedTasks() {
        return new ArrayList<Task>(this.completedTasks);
    }
}

