/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras.procfs;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsEntry;
import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ProcfsStatus
extends ProcfsEntry {
    public ProcfsStatus() {
        super(ProcfsReader.getInstance("status"));
    }

    ProcfsStatus(ProcfsReader reader) {
        super(reader);
    }

    @Override
    protected Map<ProcfsEntry.ValueKey, Double> handle(Collection<String> lines) {
        Objects.requireNonNull(lines);
        HashMap<ProcfsEntry.ValueKey, Double> values = new HashMap<ProcfsEntry.ValueKey, Double>();
        for (String line : lines) {
            if (!line.startsWith("Threads:")) continue;
            values.put(KEY.THREADS, ProcfsStatus.parseValue(line));
        }
        return values;
    }

    private static Double parseValue(String line) {
        Objects.requireNonNull(line);
        return Double.parseDouble(line.split("\\s+")[1]);
    }

    public static enum KEY implements ProcfsEntry.ValueKey
    {
        THREADS;

    }
}

