/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.utils;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.util.Optional;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.plugin.utils.PurlUtils;

@Component(role=PurlUtils.class)
public class PurlUtilsImpl
extends AbstractLogEnabled
implements PurlUtils {
    private static final String REPO1_URL = "https://repo1.maven.org/maven2/";

    @Override
    public Optional<String> toRepo1Url(String purl) {
        block3: {
            try {
                PackageURL packageURL = new PackageURL(purl);
                if (null != packageURL.getNamespace() && null != packageURL.getName() && null != packageURL.getVersion()) {
                    String url = REPO1_URL + packageURL.getNamespace().replaceAll("\\.", "/") + "/" + packageURL.getName() + "/" + packageURL.getVersion() + "/";
                    return Optional.of(url);
                }
            }
            catch (MalformedPackageURLException e) {
                if (null == this.getLogger()) break block3;
                this.getLogger().debug("Invalid package URL returned: " + purl, (Throwable)e);
            }
        }
        return Optional.empty();
    }
}

