/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.plugin.utils.HashAlgorithm;
import org.sonatype.central.publisher.plugin.utils.HashUtils;

@Component(role=HashUtils.class)
public class HashUtilsImpl
extends AbstractLogEnabled
implements HashUtils {
    @Override
    public String hash(File file, HashAlgorithm algorithm) {
        try {
            return algorithm.function().hashBytes(Files.readAllBytes(file.toPath())).toString();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to generate hash from " + file.getAbsolutePath() + " using algorithm " + algorithm, (Throwable)e);
            return null;
        }
    }

    @Override
    public File createChecksumFile(File file, HashAlgorithm algorithm) {
        File hashFile = new File(file.getParentFile(), file.getName() + "." + algorithm.name());
        try {
            String hash = this.hash(file, algorithm);
            if (hash != null) {
                return Files.write(hashFile.toPath(), hash.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING).toFile();
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to generate checksum file at " + file.getAbsolutePath() + " using algorithm " + algorithm, (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isChecksumFile(File file) {
        Optional<String> optionalExtension;
        if (file.exists() && file.isFile() && (optionalExtension = this.getExtension(file.getName())).isPresent()) {
            switch (optionalExtension.get()) {
                case "md5": 
                case "sha1": 
                case "sha256": 
                case "sha512": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isSignatureFile(File file) {
        if (file.exists() && file.isFile()) {
            return file.getName().endsWith(".asc");
        }
        return false;
    }

    private Optional<String> getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }
}

