/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.published;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.sonatype.central.publisher.client.PublisherClient;
import org.sonatype.central.publisher.client.PublisherClientFactory;
import org.sonatype.central.publisher.plugin.published.ComponentPublishedChecker;

@Component(role=ComponentPublishedChecker.class)
public class ComponentPublishedCheckerImpl
extends AbstractLogEnabled
implements ComponentPublishedChecker {
    @Requirement
    private PublisherClient publisherClient;

    public ComponentPublishedCheckerImpl() {
    }

    public ComponentPublishedCheckerImpl(PublisherClient publisherClient) {
        PublisherClient publisherClient2 = this.publisherClient = publisherClient != null ? publisherClient : PublisherClientFactory.createPublisherClient();
        if (this.getLogger() == null) {
            this.enableLogging((Logger)new ConsoleLogger());
        }
    }

    @Override
    public boolean isComponentPublished(String groupId, String artifactId, String version) {
        this.getLogger().info("Check component published status for component: groupId:" + groupId + " artifactId:" + artifactId + " version:" + version);
        boolean published = this.publisherClient.isPublished(groupId, artifactId, version);
        if (published) {
            this.getLogger().info("Excluding component: groupId:" + groupId + " artifactId:" + artifactId + " version:" + version + " as a published");
        }
        return published;
    }
}

