/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.deleter;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.client.PublisherClient;
import org.sonatype.central.publisher.client.PublisherClientFactory;
import org.sonatype.central.publisher.client.model.DeploymentApiResponse;
import org.sonatype.central.publisher.client.model.DeploymentState;
import org.sonatype.central.publisher.plugin.deleter.DeploymentDeleter;
import org.sonatype.central.publisher.plugin.exceptions.DeploymentDeleteFailedException;
import org.sonatype.central.publisher.plugin.model.DeleteDeploymentRequest;

@Component(role=DeploymentDeleter.class)
public class DeploymentDeleterImpl
extends AbstractLogEnabled
implements DeploymentDeleter {
    @Requirement
    private PublisherClient publisherClient;

    public DeploymentDeleterImpl() {
    }

    DeploymentDeleterImpl(PublisherClient publisherClient) {
        this.publisherClient = publisherClient != null ? publisherClient : PublisherClientFactory.createPublisherClient();
    }

    @Override
    public void deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        if (this.getLogger() != null) {
            this.getLogger().info("Going to delete deployment " + deleteDeploymentRequest.getDeploymentId());
        }
        try {
            DeploymentApiResponse status = this.publisherClient.status(deleteDeploymentRequest.getDeploymentId());
            if (status != null && status.getDeploymentState() == DeploymentState.VALIDATED) {
                this.publisherClient.delete(deleteDeploymentRequest.getDeploymentId());
                if (this.getLogger() != null) {
                    this.getLogger().info(String.format("Deleted deployment successfully, deployment name: %s, deploymentId: %s.", deleteDeploymentRequest.getDeploymentName(), deleteDeploymentRequest.getDeploymentId()));
                }
            } else if (this.getLogger() != null) {
                this.getLogger().info(String.format("Skipping delete for deployment %s as state is now %s (expected VALIDATED).", deleteDeploymentRequest.getDeploymentId(), status != null ? status.getDeploymentState() : "unknown"));
            }
        }
        catch (Exception e) {
            if (this.getLogger() != null) {
                this.getLogger().error(String.format("Unable to delete deployment name: %s, deploymentId: %s", deleteDeploymentRequest.getDeploymentName(), deleteDeploymentRequest.getDeploymentId()), (Throwable)e);
            }
            throw new DeploymentDeleteFailedException(deleteDeploymentRequest);
        }
    }
}

