/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin;

import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.central.publisher.plugin.utils.MojoUtils;
import org.sonatype.central.publisher.plugin.utils.ProjectUtils;

public abstract class AbstractPublisherMojo
extends AbstractMojo {
    @Parameter(property="skipPublishing", defaultValue="false", required=true)
    private boolean skipPublishing;
    @Parameter(property="skipBundling", defaultValue="false", required=false)
    private boolean skipBundling;
    @Parameter(property="failOnBuildFailure", defaultValue="true")
    private boolean failOnBuildFailure;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${plugin.groupId}", readonly=true, required=true)
    private String pluginGroupId;
    @Parameter(defaultValue="${plugin.artifactId}", readonly=true, required=true)
    private String pluginArtifactId;
    @Parameter(defaultValue="${plugin.version}", readonly=true, required=true)
    private String pluginVersion;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private MojoUtils mojoUtils;
    @Component
    private ProjectUtils projectUtils;

    protected MavenSession getMavenSession() {
        return this.mavenSession;
    }

    protected MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    protected ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    protected MojoUtils getMojoUtils() {
        return this.mojoUtils;
    }

    protected ProjectUtils getProjectUtils() {
        return this.projectUtils;
    }

    protected String getPluginGroupId() {
        return this.pluginGroupId;
    }

    protected String getPluginArtifactId() {
        return this.pluginArtifactId;
    }

    protected boolean isFailOnBuildFailure() {
        return this.failOnBuildFailure;
    }

    protected boolean isSkipPublishing() {
        return this.skipPublishing;
    }

    protected boolean isSkipBundling() {
        return this.skipBundling;
    }

    protected String getPluginGav() {
        return this.pluginGroupId + ":" + this.pluginArtifactId + ":" + this.pluginVersion;
    }

    public void execute() throws MojoExecutionException {
        this.validateParameters();
        this.doExecute();
    }

    public void validateParameters() throws MojoExecutionException {
        this.doValidateParameters();
    }

    protected abstract void doExecute() throws MojoExecutionException;

    protected abstract void doValidateParameters() throws MojoExecutionException;
}

