/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.client.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.HttpResponseException;
import org.sonatype.central.publisher.client.httpclient.PublisherHttpClient;
import org.sonatype.central.publisher.client.httpclient.RequestType;
import org.sonatype.central.publisher.client.httpclient.auth.AuthProvider;
import org.sonatype.central.publisher.client.httpclient.utils.HttpResponseUtil;

public class ComponentPublishedEndpoint {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public boolean call(String baseUrl, AuthProvider authProvider, Map<String, String> params) {
        try {
            String response = PublisherHttpClient.sendRequest(authProvider, baseUrl + "/api/v1/publisher/published", params, null, RequestType.GET);
            Map result = (Map)objectMapper.readValue(response, (TypeReference)new TypeReference<HashMap<String, Boolean>>(){});
            return (Boolean)result.get("published");
        }
        catch (HttpResponseException e) {
            throw new RuntimeException("Cannot get component published status. Response status code: " + e.getStatusCode() + " response message: " + HttpResponseUtil.toContentString(e));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

