/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.parsing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import io.github.jpmorganchase.fusion.api.response.UploadedPart;
import io.github.jpmorganchase.fusion.model.Attribute;
import io.github.jpmorganchase.fusion.model.Catalog;
import io.github.jpmorganchase.fusion.model.CatalogResource;
import io.github.jpmorganchase.fusion.model.DataProduct;
import io.github.jpmorganchase.fusion.model.Dataset;
import io.github.jpmorganchase.fusion.model.DatasetSeries;
import io.github.jpmorganchase.fusion.model.Distribution;
import io.github.jpmorganchase.fusion.model.Operation;
import io.github.jpmorganchase.fusion.parsing.APIResponseParser;
import io.github.jpmorganchase.fusion.parsing.ParsingException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonAPIResponseParser
implements APIResponseParser {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Gson gson;

    public GsonAPIResponseParser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer());
        this.gson = gsonBuilder.create();
    }

    public GsonAPIResponseParser(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Map<String, Catalog> parseCatalogResponse(String json) {
        return this.parseResourcesFromResponse(json, Catalog.class);
    }

    @Override
    public Map<String, Dataset> parseDatasetResponse(String json) {
        return this.parseResourcesFromResponse(json, Dataset.class);
    }

    @Override
    public Map<String, Attribute> parseAttributeResponse(String json) {
        return this.parseResourcesFromResponse(json, Attribute.class);
    }

    @Override
    public Map<String, DataProduct> parseDataProductResponse(String json) {
        return this.parseResourcesFromResponse(json, DataProduct.class);
    }

    @Override
    public Map<String, DatasetSeries> parseDatasetSeriesResponse(String json) {
        return this.parseResourcesFromResponse(json, DatasetSeries.class);
    }

    @Override
    public Map<String, Distribution> parseDistributionResponse(String json) {
        return this.parseResourcesFromResponse(json, Distribution.class);
    }

    @Override
    public Operation parseOperationResponse(String json) {
        return (Operation)this.gson.fromJson(json, Operation.class);
    }

    @Override
    public UploadedPart parseUploadPartResponse(String json) {
        return (UploadedPart)new GsonBuilder().create().fromJson(json, UploadedPart.class);
    }

    @Override
    public <T extends CatalogResource> Map<String, T> parseResourcesFromResponse(String json, Class<T> resourceClass) {
        JsonArray resources = this.getResources(json);
        Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{resourceClass}).getType();
        List resourceList = (List)this.gson.fromJson((JsonElement)resources, listType);
        return resourceList.stream().collect(Collectors.toMap(CatalogResource::getIdentifier, Function.identity(), (r1, r2) -> {
            logger.warn("Duplicate key '{}' found, will be ignored", (Object)r2.getIdentifier());
            return r1;
        }));
    }

    @Override
    public Map<String, Map<String, Object>> parseResourcesUntyped(String json) {
        Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
        Map responseMap = (Map)this.gson.fromJson(json, mapType);
        Object resources = responseMap.get("resources");
        if (resources instanceof List) {
            List resourceList = (List)resources;
            if (resourceList.size() == 0) {
                throw this.generateNoResourceException();
            }
            HashMap<String, Map<String, Object>> resourcesMap = new HashMap<String, Map<String, Object>>();
            resourceList.forEach(o -> {
                Map resource = (Map)o;
                String identifier = (String)resource.get("identifier");
                resourcesMap.put(identifier, resource);
            });
            return resourcesMap;
        }
        throw this.generateNoResourceException();
    }

    private JsonArray getResources(String json) {
        JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
        JsonArray array = obj.getAsJsonArray("resources");
        if (array == null || array.size() == 0) {
            throw this.generateNoResourceException();
        }
        return array;
    }

    private ParsingException generateNoResourceException() {
        String message = "Failed to parse resources from JSON, none found";
        logger.error(message);
        return new ParsingException(message);
    }

    private static final class LocalDateDeserializer
    implements JsonDeserializer<LocalDate> {
        private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        private LocalDateDeserializer() {
        }

        public LocalDate deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            try {
                return LocalDate.parse(jsonElement.getAsString(), dateTimeFormatter);
            }
            catch (DateTimeParseException e) {
                String message = "Failed to deserialize date field with value " + jsonElement.getAsString();
                logger.warn(message);
                return null;
            }
        }
    }
}

