/*
 * Decompiled with CFR 0.152.
 */
package io.github.jpmorganchase.fusion.oauth.retriever;

import io.github.jpmorganchase.fusion.http.Client;
import io.github.jpmorganchase.fusion.http.HttpResponse;
import io.github.jpmorganchase.fusion.http.JdkClient;
import io.github.jpmorganchase.fusion.oauth.credential.Credentials;
import io.github.jpmorganchase.fusion.oauth.credential.OAuthDatasetCredentials;
import io.github.jpmorganchase.fusion.oauth.credential.OAuthPasswordBasedCredentials;
import io.github.jpmorganchase.fusion.oauth.credential.OAuthSecretBasedCredentials;
import io.github.jpmorganchase.fusion.oauth.exception.OAuthException;
import io.github.jpmorganchase.fusion.oauth.model.BearerToken;
import io.github.jpmorganchase.fusion.oauth.retriever.OAuthServerResponse;
import io.github.jpmorganchase.fusion.oauth.retriever.TokenRetriever;
import io.github.jpmorganchase.fusion.time.SystemTimeProvider;
import io.github.jpmorganchase.fusion.time.TimeProvider;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthTokenRetriever
implements TokenRetriever {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Client httpClient;
    private final TimeProvider timeProvider;

    public OAuthTokenRetriever() {
        this(JdkClient.builder().noProxy().build(), new SystemTimeProvider());
    }

    public OAuthTokenRetriever(Client httpClient) {
        this(httpClient, new SystemTimeProvider());
    }

    public OAuthTokenRetriever(Client httpClient, TimeProvider timeProvider) {
        this.httpClient = httpClient;
        this.timeProvider = timeProvider;
    }

    @Override
    public BearerToken retrieve(Credentials credentials) {
        switch (credentials.getCredentialType()) {
            case SECRET: {
                return this.retrieveWithSecretCredentials((OAuthSecretBasedCredentials)credentials);
            }
            case PASSWORD: {
                return this.retrieveWithPasswordCredentials((OAuthPasswordBasedCredentials)credentials);
            }
            case DATASET: {
                return this.retrieveWithDatasetCredentials((OAuthDatasetCredentials)credentials);
            }
        }
        throw new OAuthException(String.format("Unable to retrieve token, unsupported credential type %s", credentials.getClass().getName()), "Unable to initiate request");
    }

    public BearerToken retrieveWithPasswordCredentials(OAuthPasswordBasedCredentials credentials) {
        Map<String, String> requestHeaders = this.initRequestHeaders();
        requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        String body = String.format("grant_type=password&resource=%1$s&client_id=%2$s&username=%3$s&password=%4$s", credentials.getResource(), credentials.getClientId(), credentials.getUsername(), credentials.getPassword());
        return this.retrieve(credentials.getAuthServerUrl(), requestHeaders, new ArrayList<String>(), body);
    }

    public BearerToken retrieveWithSecretCredentials(OAuthSecretBasedCredentials credentials) {
        Map<String, String> requestHeaders = this.initRequestHeaders();
        String auth = credentials.getClientId() + ":" + credentials.getClientSecret();
        String authVal = "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        requestHeaders.put("Authorization", authVal);
        requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        String body = String.format("grant_type=client_credentials&aud=%1s", credentials.getResource());
        return this.retrieve(credentials.getAuthServerUrl(), requestHeaders, new ArrayList<String>(), body);
    }

    public BearerToken retrieveWithDatasetCredentials(OAuthDatasetCredentials credentials) {
        Map<String, String> requestHeaders = this.initRequestHeaders();
        requestHeaders.put("Authorization", "Bearer " + credentials.getToken());
        return this.retrieve(credentials.getAuthServerUrl(), requestHeaders, Arrays.asList(credentials.getCatalog(), credentials.getDataset()), null);
    }

    private BearerToken retrieve(String authServerUrl, Map<String, String> requestHeaders, List<String> pathParams, String body) {
        HttpResponse<String> response = this.executeRequest(authServerUrl, requestHeaders, pathParams, body);
        if (response.isError()) {
            throw new OAuthException(String.format("Error response received from OAuth server with status code %s", response.getStatusCode()), response.getBody());
        }
        OAuthServerResponse oAuthServerResponse = OAuthServerResponse.fromJson(response.getBody());
        if (oAuthServerResponse.getAccessToken() == null) {
            String message = "Unable to parse bearer token in response from OAuth server";
            logger.error(String.format(message, new Object[0]));
            throw new OAuthException(message, response.getBody());
        }
        return BearerToken.of(oAuthServerResponse, this.timeProvider.currentTimeMillis());
    }

    private HttpResponse<String> executeRequest(String authServerUrl, Map<String, String> requestHeaders, List<String> pathParams, String body) {
        if (pathParams.size() > 0) {
            return this.httpClient.get(this.fusionAuthServerUrlForDataset(authServerUrl, pathParams), requestHeaders);
        }
        return this.httpClient.post(authServerUrl, requestHeaders, body);
    }

    private String fusionAuthServerUrlForDataset(String fusionAuthServerUrl, List<String> urlPathParams) {
        return String.format(fusionAuthServerUrl, urlPathParams.toArray());
    }

    private Map<String, String> initRequestHeaders() {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Accept", "application/json");
        return requestHeaders;
    }
}

